/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import java.util.HashMap;
import net.sf.l2j.gameserver.model.L2Object;

public class DesireTable {
    public static final DesireType[] DEFAULT_DESIRES = new DesireType[]{DesireType.FEAR, DesireType.DISLIKE, DesireType.HATE, DesireType.DAMAGE};
    private HashMap<L2Object, Desires> objectDesireTable;
    private Desires generalDesires;
    private DesireType[] desireTypes;

    public DesireTable(DesireType ... desireList) {
        this.desireTypes = desireList;
        this.objectDesireTable = new HashMap();
        this.generalDesires = new Desires(this.desireTypes);
    }

    public float getDesireValue(DesireType type) {
        return this.generalDesires.getDesireValue(type).getValue();
    }

    public float getDesireValue(L2Object object, DesireType type) {
        Desires desireList = this.objectDesireTable.get(object);
        if (desireList == null) {
            return 0.0f;
        }
        return desireList.getDesireValue(type).getValue();
    }

    public void addDesireValue(DesireType type, float value) {
        this.generalDesires.addValue(type, value);
    }

    public void addDesireValue(L2Object object, DesireType type, float value) {
        Desires desireList = this.objectDesireTable.get(object);
        if (desireList != null) {
            desireList.addValue(type, value);
        }
    }

    public void createDesire(DesireType type) {
        this.generalDesires.createDesire(type);
    }

    public void deleteDesire(DesireType type) {
        this.generalDesires.deleteDesire(type);
    }

    public void createDesire(L2Object object, DesireType type) {
        Desires desireList = this.objectDesireTable.get(object);
        if (desireList != null) {
            desireList.createDesire(type);
        }
    }

    public void deleteDesire(L2Object object, DesireType type) {
        Desires desireList = this.objectDesireTable.get(object);
        if (desireList != null) {
            desireList.deleteDesire(type);
        }
    }

    public void addKnownObject(L2Object object) {
        if (object != null) {
            this.addKnownObject(object, DesireType.DISLIKE, DesireType.FEAR, DesireType.DAMAGE, DesireType.HATE);
        }
    }

    public void addKnownObject(L2Object object, DesireType ... desireList) {
        if (object != null) {
            this.objectDesireTable.put(object, new Desires(desireList));
        }
    }

    class Desires {
        private HashMap<DesireType, DesireValue> desireTable = new HashMap();

        public Desires(DesireType ... desireList) {
            for (DesireType desire : desireList) {
                this.desireTable.put(desire, new DesireValue());
            }
        }

        public DesireValue getDesireValue(DesireType type) {
            return this.desireTable.get((Object)type);
        }

        public void addValue(DesireType type, float value) {
            DesireValue temp = this.getDesireValue(type);
            if (temp != null) {
                temp.addValue(value);
            }
        }

        public void createDesire(DesireType type) {
            this.desireTable.put(type, new DesireValue());
        }

        public void deleteDesire(DesireType type) {
            this.desireTable.remove((Object)type);
        }
    }

    class DesireValue {
        private float value;

        DesireValue() {
            this(Float.valueOf(0.0f));
        }

        DesireValue(Float value) {
            this.value = value.floatValue();
        }

        public void addValue(float value) {
            this.value += value;
        }

        public float getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DesireType {
        FEAR,
        DISLIKE,
        HATE,
        DAMAGE;

    }
}

