/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.model;

import net.sf.l2j.gameserver.model.Race;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ClassId {
    fighter(0, false, Race.human, null),
    warrior(1, false, Race.human, fighter),
    gladiator(2, false, Race.human, warrior),
    warlord(3, false, Race.human, warrior),
    knight(4, false, Race.human, fighter),
    paladin(5, false, Race.human, knight),
    darkAvenger(6, false, Race.human, knight),
    rogue(7, false, Race.human, fighter),
    treasureHunter(8, false, Race.human, rogue),
    hawkeye(9, false, Race.human, rogue),
    mage(10, true, Race.human, null),
    wizard(11, true, Race.human, mage),
    sorceror(12, true, Race.human, wizard),
    necromancer(13, true, Race.human, wizard),
    warlock(14, true, Race.human, wizard),
    cleric(15, true, Race.human, mage),
    bishop(16, true, Race.human, cleric),
    prophet(17, true, Race.human, cleric),
    elvenFighter(18, false, Race.elf, null),
    elvenKnight(19, false, Race.elf, elvenFighter),
    templeKnight(20, false, Race.elf, elvenKnight),
    swordSinger(21, false, Race.elf, elvenKnight),
    elvenScout(22, false, Race.elf, elvenFighter),
    plainsWalker(23, false, Race.elf, elvenScout),
    silverRanger(24, false, Race.elf, elvenScout),
    elvenMage(25, true, Race.elf, null),
    elvenWizard(26, true, Race.elf, elvenMage),
    spellsinger(27, true, Race.elf, elvenWizard),
    elementalSummoner(28, true, Race.elf, elvenWizard),
    oracle(29, true, Race.elf, elvenMage),
    elder(30, true, Race.elf, oracle),
    darkFighter(31, false, Race.darkelf, null),
    palusKnight(32, false, Race.darkelf, darkFighter),
    shillienKnight(33, false, Race.darkelf, palusKnight),
    bladedancer(34, false, Race.darkelf, palusKnight),
    assassin(35, false, Race.darkelf, darkFighter),
    abyssWalker(36, false, Race.darkelf, assassin),
    phantomRanger(37, false, Race.darkelf, assassin),
    darkMage(38, true, Race.darkelf, null),
    darkWizard(39, true, Race.darkelf, darkMage),
    spellhowler(40, true, Race.darkelf, darkWizard),
    phantomSummoner(41, true, Race.darkelf, darkWizard),
    shillienOracle(42, true, Race.darkelf, darkMage),
    shillenElder(43, true, Race.darkelf, shillienOracle),
    orcFighter(44, false, Race.orc, null),
    orcRaider(45, false, Race.orc, orcFighter),
    destroyer(46, false, Race.orc, orcRaider),
    orcMonk(47, false, Race.orc, orcFighter),
    tyrant(48, false, Race.orc, orcMonk),
    orcMage(49, true, Race.orc, null),
    orcShaman(50, true, Race.orc, orcMage),
    overlord(51, true, Race.orc, orcShaman),
    warcryer(52, true, Race.orc, orcShaman),
    dwarvenFighter(53, false, Race.dwarf, null),
    scavenger(54, false, Race.dwarf, dwarvenFighter),
    bountyHunter(55, false, Race.dwarf, scavenger),
    artisan(56, false, Race.dwarf, dwarvenFighter),
    warsmith(57, false, Race.dwarf, artisan);

    private final int id;
    private final boolean isMage;
    private final Race race;
    private final ClassId parent;

    private ClassId(int id, boolean isMage, Race race, ClassId parent) {
        this.id = id;
        this.isMage = isMage;
        this.race = race;
        this.parent = parent;
    }

    public final int getId() {
        return this.id;
    }

    public final boolean isMage() {
        return this.isMage;
    }

    public final Race getRace() {
        return this.race;
    }

    public final boolean childOf(ClassId cid) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == cid) {
            return true;
        }
        return this.parent.childOf(cid);
    }

    public final boolean equalsOrChildOf(ClassId cid) {
        return this == cid || this.childOf(cid);
    }

    public final int level() {
        if (this.parent == null) {
            return 0;
        }
        return 1 + this.parent.level();
    }
}

