/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.L2DatabaseFactory;

public class mysql {
    private static Logger _log = Logger.getLogger(mysql.class.getName());
    private static Connection _dbh;
    private static final mysql _instance;

    public static mysql getInstance() {
        return _instance;
    }

    private mysql() {
        _dbh = null;
        try {
            _dbh = L2DatabaseFactory.getInstance().getConnection();
        }
        catch (Exception e) {
            _log.warning("DB connection error:" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer simple_get_int(String ret_field, String table, String where) {
        String query2 = "SELECT `" + ret_field + "` FROM `" + table + "` WHERE " + where + " LIMIT 1;";
        Integer res = null;
        PreparedStatement statement = null;
        ResultSet rset = null;
        try {
            statement = _dbh.prepareStatement(query2);
            rset = statement.executeQuery();
            if (rset.next()) {
                res = rset.getInt(1);
            }
        }
        catch (Exception e) {
            _log.warning("mSGI: Error in query '" + query2 + "':" + e);
            e.printStackTrace();
        }
        finally {
            try {
                rset.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer[][] simple_get_int_array(String[] ret_fields, String table, String where) {
        long start = System.currentTimeMillis();
        String fields = null;
        for (String field : ret_fields) {
            if (fields != null) {
                fields = fields + ",";
                fields = fields + "`" + field + "`";
                continue;
            }
            fields = "`" + field + "`";
        }
        String query2 = "SELECT " + fields + " FROM `" + table + "` WHERE " + where;
        PreparedStatement statement = null;
        ResultSet rset = null;
        Integer[][] res = null;
        try {
            statement = _dbh.prepareStatement(query2);
            rset = statement.executeQuery();
            ArrayList<Integer[]> al = new ArrayList<Integer[]>();
            int row = 0;
            while (rset.next()) {
                Integer[] tmp = new Integer[ret_fields.length];
                for (int i = 0; i < ret_fields.length; ++i) {
                    tmp[i] = rset.getInt(i + 1);
                }
                al.add(row, tmp);
                ++row;
            }
            res = (Integer[][])al.toArray((T[])new Integer[row][ret_fields.length]);
        }
        catch (Exception e) {
            _log.warning("mSGIA: Error in query '" + query2 + "':" + e);
            e.printStackTrace();
        }
        finally {
            try {
                rset.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
        _log.fine("Get all rows in query '" + query2 + "' in " + (System.currentTimeMillis() - start) + "ms");
        return res;
    }

    static {
        _instance = new mysql();
    }
}

