/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf.words;

import net.sf.l2j.gameserver.lib.jbf.JBData;
import net.sf.l2j.gameserver.lib.jbf.words.Dict;
import net.sf.l2j.gameserver.lib.jbf.words.Word;

public class StackOps {
    public StackOps(Dict d) {
        d.reg("SWAP", new swap());
        d.reg("DUP", new dup());
        d.reg("?DUP", new qdup());
        d.reg("DROP", new drop());
        d.reg("NIP", new nip());
        d.reg("2DROP", new ddrop());
        d.reg("NDROP", new ndrop());
        d.reg("ROT", new rot());
        d.reg("OVER", new over());
        d.reg("PEEK", new peek());
    }

    public class peek
    extends Word {
        public void exec(JBData data) {
            data.st.set(data.st.peek(data.st.top_i()));
        }
    }

    public class over
    extends Word {
        public void exec(JBData data) {
            data.st.over();
        }
    }

    public class rot
    extends Word {
        public void exec(JBData data) {
            data.st.rot();
        }
    }

    public class ndrop
    extends Word {
        public void exec(JBData data) {
            data.st.ndrop(data.st.pop_i());
        }
    }

    public class ddrop
    extends Word {
        public void exec(JBData data) {
            data.st.ddrop();
        }
    }

    public class nip
    extends Word {
        public void exec(JBData data) {
            data.st.set(data.st.pop());
        }
    }

    public class drop
    extends Word {
        public void exec(JBData data) {
            data.st.drop();
        }
    }

    public class qdup
    extends Word {
        public void exec(JBData data) {
            Object x = data.st.top();
            if (x instanceof Integer && (Integer)x == 0) {
                return;
            }
            if (x instanceof String && (String)x == "") {
                return;
            }
            if (x == null) {
                return;
            }
            data.st.dup();
        }
    }

    public class dup
    extends Word {
        public void exec(JBData data) {
            data.st.dup();
        }
    }

    public class swap
    extends Word {
        public void exec(JBData data) {
            data.st.swap();
        }
    }
}

