/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf.words;

import java.util.concurrent.ConcurrentHashMap;
import net.sf.l2j.gameserver.lib.jbf.JBCore;
import net.sf.l2j.gameserver.lib.jbf.JBData;
import net.sf.l2j.gameserver.lib.jbf.Variable;
import net.sf.l2j.gameserver.lib.jbf.words.Dict;
import net.sf.l2j.gameserver.lib.jbf.words.Literal;
import net.sf.l2j.gameserver.lib.jbf.words.Word;

public class Memory {
    public Memory(Dict d) {
        d.reg("@", new at());
        d.reg("!", new store());
        d.reg("ON", new won());
        d.reg("OFF", new woff());
        d.reg("H!", new hstore());
        d.reg(",", new comma());
        d.reg("CONSTANT", new constant());
        d.reg("VARIABLE", new variable());
        d.reg("USER", new user());
        d.reg("M@", new mget());
        d.reg("M!", new mset());
        d.reg("NEW-HASHMAP", new new_hashmap());
    }

    public class new_hashmap
    extends Word {
        public void exec(JBData data) {
            data.st.push(new ConcurrentHashMap());
        }
    }

    public class mset
    extends Word {
        public void exec(JBData data) {
            String name = data.st.pop_s();
            ConcurrentHashMap hash = (ConcurrentHashMap)data.st.pop();
            hash.put(name, data.st.pop());
        }
    }

    public class mget
    extends Word {
        public void exec(JBData data) {
            String name = (String)data.st.pop();
            data.st.set(((ConcurrentHashMap)data.st.top()).get(name));
        }
    }

    public class user_var
    extends Word {
        private String name;

        public user_var(String _name) {
            this.name = _name;
        }

        public void exec(JBData data) {
            Variable var;
            if (!data.user_vars.containsKey(this.name)) {
                var = new Variable();
                data.user_vars.put(this.name, var);
            } else {
                var = data.user_vars.get(this.name);
            }
            data.st.push(var);
        }
    }

    public class user
    extends Word {
        public void exec(JBData data) {
            String name = this.jbc.nextWord(data);
            JBCore.dict.reg(name, new user_var(name));
        }
    }

    public class global_var
    extends Word {
        private Variable var;
        private String name;

        public global_var(String _name) {
            this.name = _name;
            if (!this.jbc.global_vars.containsKey(this.name)) {
                this.var = new Variable();
                this.jbc.global_vars.put(this.name, this.var);
            } else {
                this.var = this.jbc.global_vars.get(this.name);
            }
        }

        public void exec(JBData data) {
            data.st.push(this.var);
        }
    }

    public class variable
    extends Word {
        public void exec(JBData data) {
            String name = this.jbc.nextWord(data);
            JBCore.dict.reg(name, new global_var(name));
        }
    }

    public class constant
    extends Word {
        public void exec(JBData data) {
            JBCore.dict.reg(this.jbc.nextWord(data), new Literal(data.st.pop()));
        }
    }

    public class comma
    extends Word {
        public void exec(JBData data) {
            this.jbc.current_code.add(data.st.pop());
            ++this.jbc.current_word.Count;
        }
    }

    public class hstore
    extends Word {
        public void exec(JBData data) {
            Object[] x = data.st.pop2();
            this.jbc.current_code.set((Integer)x[0], x[1]);
        }
    }

    public class woff
    extends Word {
        public void exec(JBData data) {
            ((Variable)data.st.pop()).set(0);
        }
    }

    public class won
    extends Word {
        public void exec(JBData data) {
            ((Variable)data.st.pop()).set(-1);
        }
    }

    public class store
    extends Word {
        public void exec(JBData data) {
            Object[] x = data.st.pop2();
            ((Variable)x[0]).set(x[1]);
        }
    }

    public class at
    extends Word {
        public void exec(JBData data) {
            data.st.set(((Variable)data.st.top()).get());
        }
    }
}

