/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf.words;

import java.util.logging.Logger;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.lib.jbf.JBData;
import net.sf.l2j.gameserver.lib.jbf.words.Dict;
import net.sf.l2j.gameserver.lib.jbf.words.Word;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class L2j_items {
    static Logger _log = Logger.getLogger(L2j_items.class.getName());

    public L2j_items(Dict d) {
        d.reg("INVENTORY+!", new inventory_add());
        d.reg("INVENTORY-!", new inventory_del());
        d.reg("INVENTORY?", new inventory_exists());
        d.reg("ADENA@", new adena_at());
        d.reg("ADENA+!", new adena_add());
        d.reg("ADENA-!", new adena_sub());
    }

    public class adena_sub
    extends Word {
        public void exec(JBData data) {
            L2PcInstance player = (L2PcInstance)data.st.pop();
            player.addAdena(-((Integer)data.st.pop()).intValue());
            player.sendPacket(new ItemList(player, true));
        }
    }

    public class adena_add
    extends Word {
        public void exec(JBData data) {
            L2PcInstance player = (L2PcInstance)data.st.pop();
            player.addAdena((Integer)data.st.pop());
            player.sendPacket(new ItemList(player, true));
        }
    }

    public class adena_at
    extends Word {
        public void exec(JBData data) {
            L2PcInstance player = (L2PcInstance)data.st.pop();
            data.st.push(player.getAdena());
        }
    }

    public class inventory_exists
    extends Word {
        public void exec(JBData data) {
            L2PcInstance player = (L2PcInstance)data.st.pop();
            Integer item_id = (Integer)data.st.pop();
            L2ItemInstance item = player.getInventory().getItemByItemId(item_id);
            if (item == null) {
                data.st.push(0);
            } else {
                data.st.push(item.getCount());
            }
        }
    }

    public class inventory_del
    extends Word {
        public void exec(JBData data) {
            L2PcInstance player = (L2PcInstance)data.st.pop();
            Integer count = (Integer)data.st.pop();
            Integer item_id = (Integer)data.st.pop();
            L2ItemInstance item = player.getInventory().destroyItemByItemId(item_id, count);
            if (item == null) {
                data.st.push(-1);
            } else {
                data.st.push(item.getCount());
            }
            player.sendPacket(new ItemList(player, true));
            SystemMessage sm = new SystemMessage(614);
            sm.addString("You have lost " + (count > 1 ? count + " " + item + "s" : item) + " from your inventory.");
            player.sendPacket(sm);
        }
    }

    public class inventory_add
    extends Word {
        public void exec(JBData data) {
            L2PcInstance player = (L2PcInstance)data.st.pop();
            Integer count = (Integer)data.st.pop();
            Integer item_id = (Integer)data.st.pop();
            L2ItemInstance item = ItemTable.getInstance().createItem(item_id);
            if (!item.isStackable()) {
                for (int i = 0; i < count; ++i) {
                    player.getInventory().addItem(ItemTable.getInstance().createItem(item_id));
                }
            } else {
                item.setCount(item.getCount() + (count - 1));
                player.getInventory().addItem(item);
            }
            player.sendPacket(new ItemList(player, true));
            SystemMessage sm = new SystemMessage(614);
            sm.addString("You have add " + (count > 1 ? count + " " + item + "s" : item) + " in your inventory.");
            player.sendPacket(sm);
        }
    }
}

