/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.lib.jbf.words;

import net.sf.l2j.gameserver.lib.jbf.JBData;
import net.sf.l2j.gameserver.lib.jbf.words.Dict;
import net.sf.l2j.gameserver.lib.jbf.words.Word;

public class FloatOps {
    public FloatOps(Dict d) {
        d.reg("F>", new ffrom());
        d.reg("F+", new fadd());
        d.reg("F-", new fsub());
        d.reg("F*", new fmul());
        d.reg("F/", new fdiv());
        d.reg("FROUND", new fround());
    }

    protected static final Double any2f(Object x) {
        if (x instanceof Double) {
            return (Double)x;
        }
        if (x instanceof Integer) {
            return 0.0 + (double)((Integer)x).intValue();
        }
        return Double.parseDouble("" + x);
    }

    public class fround
    extends Word {
        public void exec(JBData data) {
            Double prec = (Double)data.st.pop();
            data.st.set(prec * (double)Math.round((Double)data.st.top() / prec));
        }
    }

    public class fdiv
    extends Word {
        public void exec(JBData data) {
            Double x = FloatOps.any2f(data.st.pop());
            data.st.set(FloatOps.any2f(data.st.top()) / x);
        }
    }

    public class fmul
    extends Word {
        public void exec(JBData data) {
            data.st.set(FloatOps.any2f(data.st.pop()) * FloatOps.any2f(data.st.top()));
        }
    }

    public class fsub
    extends Word {
        public void exec(JBData data) {
            Double x = FloatOps.any2f(data.st.pop());
            data.st.set(FloatOps.any2f(data.st.top()) - x);
        }
    }

    public class fadd
    extends Word {
        public void exec(JBData data) {
            data.st.set(FloatOps.any2f(data.st.pop()) + FloatOps.any2f(data.st.top()));
        }
    }

    public class ffrom
    extends Word {
        public void exec(JBData data) {
            data.st.set(FloatOps.any2f(data.st.top()).intValue());
        }
    }
}

