/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.Random;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.SkillTreeTable;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.ClassId;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2MonsterInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class Spoil
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(Spoil.class.getName());
    protected L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.SPOIL};

    public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets) {
        if (!(activeChar instanceof L2PcInstance)) {
            return;
        }
        L2Object[] targetList = skill.getTargetList(activeChar);
        if (targetList == null) {
            return;
        }
        for (int index = 0; index < targetList.length; ++index) {
            if (!(targetList[index] instanceof L2MonsterInstance)) continue;
            L2MonsterInstance target = (L2MonsterInstance)targetList[index];
            boolean spoil = false;
            if (!target.isDead()) {
                int randomSuccessRate;
                boolean canSpoilLowerLevel = Config.CAN_SPOIL_LOWER_LEVEL_MOBS;
                boolean canDelevelToSpoil = Config.CAN_DELEVEL_AND_SPOIL_MOBS;
                boolean wasNegative = false;
                boolean delevelledPlayer = false;
                double x = 0.0;
                double lvlDifference = 0.0;
                double rateOfSpoil = 0.0;
                double maxLevelDifference = Config.MAXIMUM_PLAYER_AND_MOB_LEVEL_DIFFERENCE;
                double baseRateOfSpoil = Config.BASE_SPOIL_RATE;
                double minimumRateOfSpoil = Config.MINIMUM_SPOIL_RATE;
                double spoilLevelLimit = Config.SPOIL_LEVEL_DIFFERENCE_LIMIT;
                int maxLevelOfSpoil = Config.LAST_LEVEL_SPOIL_IS_LEARNED;
                int mobLevel = target.getLevel();
                int playerLevel = activeChar.getLevel();
                int spoilCheck = 0;
                int spoilLevelANDPlayerLevelDifference = 0;
                Random rand = new Random();
                lvlDifference = mobLevel - playerLevel;
                x = lvlDifference / maxLevelDifference;
                if (x < 0.0) {
                    x *= -1.0;
                    wasNegative = true;
                }
                if (canSpoilLowerLevel && wasNegative) {
                    rateOfSpoil = baseRateOfSpoil;
                } else {
                    if (x > 1.0) {
                        x = 1.0;
                    }
                    if ((rateOfSpoil = baseRateOfSpoil * (1.0 - Math.pow(x, 2.0))) < minimumRateOfSpoil) {
                        rateOfSpoil = minimumRateOfSpoil;
                    }
                }
                if (playerLevel > maxLevelOfSpoil) {
                    playerLevel = maxLevelOfSpoil;
                }
                L2PcInstance activecharPC = L2World.getInstance().getPlayer(activeChar.getName());
                ClassId classID = activecharPC.getClassId();
                spoilCheck = SkillTreeTable.getMinSkillLevel(skill.getId(), classID, skill.getLevel());
                spoilLevelANDPlayerLevelDifference = playerLevel - spoilCheck;
                if (spoilLevelANDPlayerLevelDifference < 0) {
                    if (canDelevelToSpoil) {
                        delevelledPlayer = true;
                    } else {
                        spoilLevelANDPlayerLevelDifference *= -1;
                        delevelledPlayer = false;
                    }
                }
                if ((double)spoilLevelANDPlayerLevelDifference > spoilLevelLimit && !delevelledPlayer) {
                    double rateOfSpoilMultiplier;
                    if ((spoilLevelANDPlayerLevelDifference = (int)((double)spoilLevelANDPlayerLevelDifference / spoilLevelLimit)) < 0) {
                        spoilLevelANDPlayerLevelDifference *= -1;
                    }
                    if (spoilLevelANDPlayerLevelDifference > 1) {
                        spoilLevelANDPlayerLevelDifference = 1;
                    }
                    if ((rateOfSpoil *= (rateOfSpoilMultiplier = baseRateOfSpoil * (1.0 - Math.pow(spoilLevelANDPlayerLevelDifference, 2.0)) / 100.0)) < minimumRateOfSpoil) {
                        rateOfSpoil = minimumRateOfSpoil;
                    }
                }
                if ((double)(randomSuccessRate = rand.nextInt(99)) < rateOfSpoil) {
                    spoil = true;
                }
            }
            if (spoil) {
                target.activateSpoil();
                activeChar.sendPacket(new SystemMessage(612));
            } else {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Spoil failed");
                activeChar.sendPacket(sm);
            }
            target.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, activeChar);
            activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return this._skillIds;
    }
}

