/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Logger;
import net.sf.l2j.gameserver.IdFactory;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class SiegeFlag
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(SiegeFlag.class.getName());
    protected L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.SIEGEFLAG};

    public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets) {
        if (!(activeChar instanceof L2PcInstance)) {
            return;
        }
        L2PcInstance target = (L2PcInstance)activeChar;
        int monsterId = 12024;
        int TYPE = L2Siege.getFlagItem();
        int COST = L2Siege.getFlagCost();
        L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(monsterId);
        if (template1 == null) {
            // empty if block
        }
        try {
            int x = target.getX();
            int y = target.getY();
            int z = target.getZ();
            L2Clan playersClan = target.getClan();
            L2ItemInstance itemToTake = target.getInventory().getItemByItemId(TYPE);
            if (playersClan == null) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("You must be a clan leader to place a flag");
                target.sendPacket(sm);
                return;
            }
            if (itemToTake == null) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("You do not have the required construction items");
                target.sendPacket(sm);
                return;
            }
            if (!L2Siege.okToPlaceFlag(playersClan.getClanId())) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("You have already placed the maximum number of flags possible");
                target.sendPacket(sm);
                return;
            }
            int itemCount = itemToTake.getCount();
            if (itemCount >= COST && L2Siege.isAttacker(target.getClanId()) && target.getObjectId() == playersClan.getLeaderId()) {
                itemToTake.setCount(itemCount - COST);
                if (itemCount - COST == 0) {
                    itemToTake.decayMe();
                }
                int flagId = IdFactory.getInstance().getNextId();
                L2NpcInstance flag = new L2NpcInstance(flagId, template1);
                flag.setName("" + playersClan.getName() + " Siege Flag");
                flag.setCurrentHpMp(flag.getMaxHp() / 3, flag.getMaxMp());
                flag.setHeading(target.getHeading());
                System.out.println(target.getHeading());
                flag.spawnMe(x, y, z + 100);
                L2Siege.setFlag(target.getClanId(), flag);
            } else {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("You cannot place a siege flag");
                target.sendPacket(sm);
            }
        }
        catch (Exception e) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Error placing flag:" + e);
            target.sendPacket(sm);
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return this._skillIds;
    }
}

