/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Formulas;

public class Pdam
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(Pdam.class.getName());
    private static L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.PDAM};

    public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets) {
        if (activeChar.isAlikeDead()) {
            return;
        }
        int damage = 0;
        if (Config.DEBUG && Config.DEBUG) {
            _log.fine("Begin Skill processing in Pdam.java " + (Object)((Object)skill.getSkillType()));
        }
        for (int index = 0; index < targets.length; ++index) {
            SystemMessage sm;
            L2Character target = (L2Character)targets[index];
            if (target.isAlikeDead()) continue;
            boolean dual = activeChar.isUsingDualWeapon();
            boolean shld = Formulas.getInstance().calcShldUse(activeChar, target);
            boolean crit = Formulas.getInstance().calcCrit(activeChar.getCriticalHit(target, skill));
            damage = !crit && (skill.getCondition() & 0x10) != 0 ? 0 : (int)Formulas.getInstance().calcPhysDam(activeChar, target, skill, shld, crit, dual, false);
            if (damage > 0) {
                target.reduceCurrentHp(damage, activeChar);
                if (activeChar instanceof L2PcInstance) {
                    sm = new SystemMessage(35);
                    sm.addNumber(damage);
                    activeChar.sendPacket(sm);
                }
                target.stopEffect(skill.getId());
                if (target.getEffect(skill.getId()) != null) {
                    target.removeEffect(target.getEffect(skill.getId()));
                }
                skill.getEffects(activeChar, target);
                continue;
            }
            sm = new SystemMessage(614);
            sm.addString(skill.getName() + " failed.");
            activeChar.sendPacket(sm);
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return _skillIds;
    }
}

