/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Logger;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Formulas;

public class Mdam
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(Mdam.class.getName());
    private static L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.MDAM};

    public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets) {
        if (activeChar.isAlikeDead()) {
            return;
        }
        boolean ss = false;
        boolean bss = false;
        L2ItemInstance weaponInst = activeChar.getActiveWeaponInstance();
        if (activeChar instanceof L2PcInstance && weaponInst == null) {
            SystemMessage sm2 = new SystemMessage(614);
            sm2.addString("You must equip one weapon before cast spell.");
            activeChar.sendPacket(sm2);
            return;
        }
        if (weaponInst != null) {
            if (weaponInst.getChargedSpiritshot() == 2) {
                bss = true;
                weaponInst.setChargedSpiritshot(0);
            } else if (weaponInst.getChargedSpiritshot() == 1) {
                ss = true;
                weaponInst.setChargedSpiritshot(0);
            }
        }
        for (int index = 0; index < targets.length; ++index) {
            L2Character target = (L2Character)targets[index];
            if (target.isAlikeDead()) continue;
            boolean mcrit = Formulas.getInstance().calcMCrit(activeChar.getMCriticalHit(target, skill));
            int damage = (int)Formulas.getInstance().calcMagicDam(activeChar, target, skill, ss, bss, mcrit);
            target.reduceCurrentHp(damage, activeChar);
            if (activeChar instanceof L2PcInstance) {
                SystemMessage sm = new SystemMessage(35);
                sm.addNumber(damage);
                activeChar.sendPacket(sm);
            }
            target.stopEffect(skill.getId());
            if (target.getEffect(skill.getId()) != null) {
                target.removeEffect(target.getEffect(skill.getId()));
            }
            skill.getEffects(activeChar, target);
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return _skillIds;
    }
}

