/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Logger;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class Heal
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(Heal.class.getName());
    private static L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.HEAL};

    public void useSkill(L2Character actChar, L2Skill skill, L2Object[] targets) {
        L2Character target = null;
        L2ItemInstance weaponInst = actChar.getActiveWeaponInstance();
        for (int index = 0; index < targets.length; ++index) {
            target = (L2Character)targets[index];
            double hp = skill.getPower();
            if (weaponInst != null && weaponInst.getChargedSpiritshot() == 2) {
                hp *= 1.5;
                weaponInst.setChargedSpiritshot(0);
            }
            if (weaponInst != null && weaponInst.getChargedSpiritshot() == 1) {
                hp *= 1.3;
                weaponInst.setChargedSpiritshot(0);
            }
            target.setCurrentHp(hp + target.getCurrentHp());
            StatusUpdate suhp = new StatusUpdate(target.getObjectId());
            suhp.addAttribute(StatusUpdate.CUR_HP, (int)target.getCurrentHp());
            target.sendPacket(suhp);
            if (!(target instanceof L2PcInstance)) continue;
            SystemMessage sm2 = new SystemMessage(614);
            sm2.addString((int)hp + " HPs have been restored.");
            target.sendPacket(sm2);
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return _skillIds;
    }
}

