/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import java.util.logging.Logger;
import net.sf.l2j.gameserver.ai.CtrlEvent;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.L2Attackable;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Formulas;

public class Disablers
implements ISkillHandler {
    private static Logger _log = Logger.getLogger(Disablers.class.getName());
    protected L2Skill.SkillType[] _skillIds = new L2Skill.SkillType[]{L2Skill.SkillType.STUN, L2Skill.SkillType.ROOT, L2Skill.SkillType.SLEEP, L2Skill.SkillType.CONFUSION, L2Skill.SkillType.AGGDAMAGE, L2Skill.SkillType.AGGREDUCE, L2Skill.SkillType.AGGREDUCE_CHAR, L2Skill.SkillType.AGGREMOVE, L2Skill.SkillType.UNBLEED, L2Skill.SkillType.UNPOISON, L2Skill.SkillType.MUTE, L2Skill.SkillType.FAKE_DEATH, L2Skill.SkillType.CONFUSE_MOB_ONLY, L2Skill.SkillType.NEGATE, L2Skill.SkillType.PARALYZE};

    public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets) {
        L2Skill.SkillType type = skill.getSkillType();
        block14: for (int index = 0; index < targets.length; ++index) {
            if (!(targets[index] instanceof L2Character)) continue;
            L2Character target = (L2Character)targets[index];
            switch (type) {
                case FAKE_DEATH: 
                case PARALYZE: 
                case STUN: {
                    skill.getEffects(activeChar, target);
                    continue block14;
                }
                case ROOT: {
                    boolean successRoot = Formulas.getInstance().calcSkillSuccess(activeChar, target, skill);
                    if (successRoot) {
                        skill.getEffects(activeChar, target);
                        continue block14;
                    }
                    SystemMessage sm = new SystemMessage(614);
                    sm.addString(skill.getName() + " failed.");
                    if (!(activeChar instanceof L2PcInstance)) continue block14;
                    activeChar.sendPacket(sm);
                    continue block14;
                }
                case SLEEP: {
                    boolean successSleep = Formulas.getInstance().calcSkillSuccess(activeChar, target, skill);
                    if (successSleep) {
                        skill.getEffects(activeChar, target);
                        continue block14;
                    }
                    SystemMessage sm = new SystemMessage(614);
                    sm.addString(skill.getName() + " failed.");
                    if (!(activeChar instanceof L2PcInstance)) continue block14;
                    activeChar.sendPacket(sm);
                    continue block14;
                }
                case CONFUSION: 
                case MUTE: {
                    L2Effect[] effects;
                    for (L2Effect e : effects = target.getAllEffects()) {
                        if (e.getSkill().getSkillType() != type) continue;
                        e.exit();
                    }
                    if (Formulas.getInstance().calcMagicAffected(activeChar, target, skill)) {
                        skill.getEffects(activeChar, target);
                        continue block14;
                    }
                    SystemMessage sm = new SystemMessage(614);
                    sm.addString(skill.getName() + " failed.");
                    if (!(activeChar instanceof L2PcInstance)) continue block14;
                    activeChar.sendPacket(sm);
                    continue block14;
                }
                case CONFUSE_MOB_ONLY: {
                    if (!(target instanceof L2Attackable)) continue block14;
                    skill.getEffects(activeChar, target);
                    continue block14;
                }
                case AGGDAMAGE: {
                    if (!(target instanceof L2Attackable)) continue block14;
                    target.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, activeChar, (int)skill.getPower());
                    continue block14;
                }
                case AGGREDUCE: {
                    if (!(target instanceof L2Attackable)) continue block14;
                    target.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, null, -((int)skill.getPower()));
                    continue block14;
                }
                case AGGREDUCE_CHAR: {
                    if (!(target instanceof L2Attackable)) continue block14;
                    target.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, activeChar, -((int)skill.getPower()));
                    continue block14;
                }
                case AGGREMOVE: {
                    if ((skill.getTargetType() != L2Skill.SkillTargetType.TARGET_UNDEAD || !target.isUndead()) && !target.isAttackable()) continue block14;
                    target.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, null, -((int)skill.getPower()));
                    continue block14;
                }
                case UNBLEED: {
                    L2Effect[] effects;
                    for (L2Effect e : effects = target.getAllEffects()) {
                        if (e.getSkill().getSkillType() != L2Skill.SkillType.BLEED || !(skill.getPower() >= e.getSkill().getPower())) continue;
                        e.exit();
                        continue block14;
                    }
                    continue block14;
                }
                case UNPOISON: {
                    L2Effect[] effects;
                    for (L2Effect e : effects = target.getAllEffects()) {
                        if (e.getSkill().getSkillType() != L2Skill.SkillType.POISON || !(skill.getPower() >= e.getSkill().getPower())) continue;
                        e.exit();
                        continue block14;
                    }
                    continue block14;
                }
                case NEGATE: {
                    L2Effect[] effects;
                    if (skill.getId() == 1056) {
                        L2Effect[] effects2;
                        for (L2Effect e : effects2 = target.getAllEffects()) {
                            e.exit();
                        }
                        continue block14;
                    }
                    if (skill.getId() == 1018) {
                        L2Effect[] effects3;
                        for (L2Effect e : effects3 = target.getAllEffects()) {
                            if (skill.getLevel() == 1) {
                                if (!(e.getSkill().getSkillType() == L2Skill.SkillType.BLEED && e.getSkill().getLevel() == 1 || e.getSkill().getSkillType() == L2Skill.SkillType.POISON && e.getSkill().getLevel() == 1) && (e.getSkill().getSkillType() != L2Skill.SkillType.PARALYZE || e.getSkill().getLevel() != 1)) continue;
                                e.exit();
                                continue;
                            }
                            if (e.getSkill().getSkillType() != L2Skill.SkillType.BLEED && e.getSkill().getSkillType() != L2Skill.SkillType.POISON && e.getSkill().getSkillType() != L2Skill.SkillType.PARALYZE) continue;
                            e.exit();
                        }
                        continue block14;
                    }
                    if (skill.getId() != 1020) continue block14;
                    for (L2Effect e : effects = target.getAllEffects()) {
                        if (skill.getLevel() < 6) {
                            if ((e.getSkill().getSkillType() != L2Skill.SkillType.BLEED || e.getSkill().getLevel() != 1) && (e.getSkill().getSkillType() != L2Skill.SkillType.POISON || e.getSkill().getLevel() != 1)) continue;
                            e.exit();
                            continue;
                        }
                        if (e.getSkill().getSkillType() != L2Skill.SkillType.BLEED && e.getSkill().getSkillType() != L2Skill.SkillType.POISON) continue block14;
                        e.exit();
                        continue block14;
                    }
                    continue block14;
                }
            }
        }
    }

    public L2Skill.SkillType[] getSkillIds() {
        return this._skillIds;
    }
}

