/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.itemhandlers;

import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.MapRegionTable;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.handler.IItemHandler;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PlayableInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.Location;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.MagicSkillUser;
import net.sf.l2j.gameserver.serverpackets.SetupGauge;
import net.sf.l2j.gameserver.serverpackets.StopMove;

public class ScrollOfEscape
implements IItemHandler {
    private static int[] _itemIds = new int[]{736, 1830, 1829};

    public void useItem(L2PlayableInstance playable, L2ItemInstance item) {
        if (!(playable instanceof L2PcInstance)) {
            return;
        }
        L2PcInstance activeChar = (L2PcInstance)playable;
        if (activeChar.isMovementDisabled()) {
            return;
        }
        activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        activeChar.setTarget(activeChar);
        activeChar.disableAllSkills();
        L2Skill skill = SkillTable.getInstance().getInfo(2013, 1);
        MagicSkillUser msk = new MagicSkillUser(activeChar, 2013, 1, skill.getSkillTime(), 0);
        activeChar.sendPacket(msk);
        activeChar.broadcastPacket(msk);
        SetupGauge sg = new SetupGauge(0, skill.getSkillTime());
        activeChar.sendPacket(sg);
        activeChar.removeItemFromInventory(item, 1);
        EscapeFinalizer ef = new EscapeFinalizer(activeChar, item.getItemId());
        ClientScheduler.getInstance().scheduleLow(ef, skill.getSkillTime());
    }

    public int[] getItemIds() {
        return _itemIds;
    }

    static class EscapeFinalizer
    implements Runnable {
        private L2PcInstance _activeChar;
        private int _itemId;

        EscapeFinalizer(L2PcInstance activeChar, int itemId) {
            this._activeChar = activeChar;
            this._itemId = itemId;
        }

        public void run() {
            if (this._activeChar.isDead()) {
                return;
            }
            this._activeChar.enableAllSkills();
            try {
                L2Clan playersClan = this._activeChar.getClan();
                if (playersClan == null || this._itemId != 1830) {
                    this.escapeToTown();
                } else if (playersClan.getHasCastle() > 0) {
                    this.escapeToCastle(playersClan.getHasCastle() - 1);
                } else {
                    this.escapeToTown();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private void escapeToCastle(int castleNum) {
            StopMove sm = new StopMove(this._activeChar);
            this._activeChar.sendPacket(sm);
            this._activeChar.broadcastPacket(sm);
            ActionFailed af = new ActionFailed();
            this._activeChar.sendPacket(af);
            this._activeChar.teleToLocation(L2World.castleownerspawns[castleNum][0], L2World.castleownerspawns[castleNum][1], L2World.castleownerspawns[castleNum][2]);
        }

        private void escapeToTown() {
            Location townCords = MapRegionTable.getInstance().getClosestTownCords(this._activeChar);
            StopMove sm = new StopMove(this._activeChar);
            this._activeChar.sendPacket(sm);
            this._activeChar.broadcastPacket(sm);
            ActionFailed af = new ActionFailed();
            this._activeChar.sendPacket(af);
            this._activeChar.teleToLocation(townCords.getX(), townCords.getY(), townCords.getZ());
        }
    }
}

