/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.itemhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.handler.IItemHandler;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PetInstance;
import net.sf.l2j.gameserver.model.L2PlayableInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.MagicSkillLaunched;
import net.sf.l2j.gameserver.serverpackets.MagicSkillUser;
import net.sf.l2j.gameserver.serverpackets.PetInfo;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

public class PetSummon
implements IItemHandler {
    protected static Logger _log = Logger.getLogger(PetSummon.class.getName());
    private static final int[] _itemIds = new int[]{2375, 3500, 3501, 3502, 4422, 4423, 4424};

    public void useItem(L2PlayableInstance playable, L2ItemInstance item) {
        int npcId;
        if (!(playable instanceof L2PcInstance)) {
            return;
        }
        L2PcInstance activeChar = (L2PcInstance)playable;
        if (activeChar.getPet() != null) {
            if (Config.DEBUG) {
                _log.fine("player has a pet already. ignore use item");
            }
            return;
        }
        if (activeChar.isMounted()) {
            return;
        }
        switch (item.getItemId()) {
            case 2375: {
                npcId = 12077;
                break;
            }
            case 3500: {
                npcId = 12311;
                break;
            }
            case 3501: {
                npcId = 12312;
                break;
            }
            case 3502: {
                npcId = 12313;
                break;
            }
            case 4422: {
                npcId = 12526;
                break;
            }
            case 4423: {
                npcId = 12527;
                break;
            }
            case 4424: {
                npcId = 12528;
                break;
            }
            default: {
                return;
            }
        }
        L2NpcTemplate petTemplate = NpcTable.getInstance().getTemplate(npcId);
        L2PetInstance newpet = L2PetInstance.spawnPet(petTemplate, activeChar, item);
        if (newpet == null) {
            return;
        }
        newpet.setTitle(activeChar.getName());
        if (!newpet.isRespawned()) {
            newpet.setCurrentHp(newpet.getMaxHp());
            newpet.setCurrentMp(newpet.getMaxMp());
            newpet.setExp(newpet.getExpForThisLevel());
            newpet.setCurrentFed(newpet.getMaxFed());
        }
        newpet.setRunning();
        if (!newpet.isRespawned()) {
            newpet.store();
        }
        activeChar.setPet(newpet);
        MagicSkillUser msk = new MagicSkillUser(activeChar, 2046, 1, 1000, 600000);
        activeChar.sendPacket(msk);
        SystemMessage sm2 = new SystemMessage(547);
        activeChar.sendPacket(sm2);
        L2World.getInstance().storeObject(newpet);
        newpet.spawnMe(activeChar.getX() + 50, activeChar.getY() + 100, activeChar.getZ());
        PetInfo pInfo = new PetInfo(newpet);
        activeChar.sendPacket(pInfo);
        newpet.startFeed();
        ClientScheduler.getInstance().scheduleLow(new SummonFinalizer(activeChar, newpet), 900L);
    }

    public int[] getItemIds() {
        return _itemIds;
    }

    static class SummonFinalizer
    implements Runnable {
        private L2PcInstance _activeChar;
        private L2PetInstance _newpet;

        SummonFinalizer(L2PcInstance activeChar, L2PetInstance newpet) {
            this._activeChar = activeChar;
            this._newpet = newpet;
        }

        public void run() {
            try {
                this._activeChar.sendPacket(new MagicSkillLaunched(this._activeChar, 2046, 1));
                this._newpet.setFollowStatus(true);
                this._newpet.setShowSummonAnimation(false);
            }
            catch (Throwable e) {
                _log.severe(e.toString());
            }
        }
    }
}

