/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminTarget
implements IAdminCommandHandler {
    private static String[] _adminCommands = new String[]{"admin_target"};
    private static final int REQUIRED_LEVEL = Config.GM_MIN;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.startsWith("admin_target")) {
            this.handleTarget(command, activeChar);
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void handleTarget(String command, L2PcInstance activeChar) {
        try {
            String targetName = command.substring(13);
            L2PcInstance obj = L2World.getInstance().getPlayer(targetName);
            if (obj != null && obj instanceof L2PcInstance) {
                ((L2Object)obj).onAction(activeChar);
            } else {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Player " + targetName + " not found");
                activeChar.sendPacket(sm);
            }
        }
        catch (IndexOutOfBoundsException e) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Please specify correct name.");
            activeChar.sendPacket(sm);
        }
    }
}

