/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminHelpPage;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.MagicSkillUser;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminSkill
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminSkill.class.getName());
    private static String[] _adminCommands = new String[]{"admin_show_skills", "admin_remove_skills", "admin_skill_list", "admin_skill_index", "admin_add_skill", "admin_remove_skill", "admin_get_skills", "admin_reset_skills"};
    private static final int REQUIRED_LEVEL = Config.GM_CHAR_EDIT;
    private static L2Skill[] adminSkills;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.equals("admin_show_skills")) {
            this.showSkillsPage(activeChar);
        } else if (command.equals("admin_remove_skills")) {
            this.removeSkillsPage(activeChar);
        } else if (command.startsWith("admin_skill_list")) {
            AdminHelpPage.showHelpPage(activeChar, "skills.htm");
        } else if (command.startsWith("admin_skill_index")) {
            String val = command.substring(18);
            AdminHelpPage.showHelpPage(activeChar, "skills/" + val + ".htm");
        } else if (command.startsWith("admin_add_skill")) {
            try {
                String val = command.substring(15);
                this.adminAddSkill(activeChar, val);
            }
            catch (StringIndexOutOfBoundsException e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Error while adding skill.");
                activeChar.sendPacket(sm);
            }
        } else if (command.startsWith("admin_remove_skill")) {
            try {
                String id = command.substring(19);
                int idval = Integer.parseInt(id);
                this.adminRemoveSkill(activeChar, idval);
            }
            catch (StringIndexOutOfBoundsException e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Error while removing skill.");
                activeChar.sendPacket(sm);
            }
        } else if (command.equals("admin_get_skills")) {
            this.adminGetSkills(activeChar);
        } else if (command.equals("admin_reset_skills")) {
            this.adminResetSkills(activeChar);
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void removeSkillsPage(L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        L2Skill[] skills = player.getAllSkills();
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Character Selection Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_show_skills\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        replyMSG.append("<center>Editing character: " + player.getName() + "</center>");
        replyMSG.append("<br><table width=270><tr><td>Lv: " + player.getLevel() + " " + player.getTemplate().className + "</td></tr></table>");
        replyMSG.append("<br><table width=270><tr><td>Note: Dont forget that modifying players skills can</td></tr>");
        replyMSG.append("<tr><td>ruin the game...</td></tr></table>");
        replyMSG.append("<br><center>Click on the skill you wish to remove:</center>");
        replyMSG.append("<br><table width=270>");
        replyMSG.append("<tr><td width=80>Name:</td><td width=60>Level:</td><td width=40>Id:</td></tr>");
        for (int i = 0; i < skills.length; ++i) {
            replyMSG.append("<tr><td width=80><a action=\"bypass -h admin_remove_skill " + skills[i].getId() + "\">" + skills[i].getName() + "</a></td><td width=60>" + skills[i].getLevel() + "</td><td width=40>" + skills[i].getId() + "</td></tr>");
        }
        replyMSG.append("</table>");
        replyMSG.append("<br><center><table>");
        replyMSG.append("Remove custom skill:");
        replyMSG.append("<tr><td>Id: </td>");
        replyMSG.append("<td><edit var=\"id_to_remove\" width=110></td></tr>");
        replyMSG.append("</table></center>");
        replyMSG.append("<center><button value=\"Remove skill\" action=\"bypass -h admin_remove_skill $id_to_remove\" width=110 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></center>");
        replyMSG.append("<br><center><button value=\"Back\" action=\"bypass -h admin_current_player\" width=40 height=15></center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    private void showSkillsPage(L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Character Selection Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_current_player\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        replyMSG.append("<center>Editing character: " + player.getName() + "</center>");
        replyMSG.append("<br><table width=270><tr><td>Lv: " + player.getLevel() + " " + player.getTemplate().className + "</td></tr></table>");
        replyMSG.append("<br><table width=270><tr><td>Note: Dont forget that modifying players skills can</td></tr>");
        replyMSG.append("<tr><td>ruin the game...</td></tr></table>");
        replyMSG.append("<br><center><table>");
        replyMSG.append("<tr><td><button value=\"Add skills\" action=\"bypass -h admin_skill_list\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"Get skills\" action=\"bypass -h admin_get_skills\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("<tr><td><button value=\"Delete skills\" action=\"bypass -h admin_remove_skills\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"Reset skills\" action=\"bypass -h admin_reset_skills\" width=70 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("</table></center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    private void adminGetSkills(L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        if (player.getName().equals(activeChar.getName())) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("There is no point in doing it on your character...");
            player.sendPacket(sm);
        } else {
            int i;
            L2Skill[] skills = player.getAllSkills();
            adminSkills = activeChar.getAllSkills();
            for (i = 0; i < adminSkills.length; ++i) {
                activeChar.removeSkill(adminSkills[i]);
            }
            for (i = 0; i < skills.length; ++i) {
                activeChar.addSkill(skills[i]);
            }
            SystemMessage smA = new SystemMessage(614);
            smA.addString("You now have all the skills of  " + player.getName() + ".");
            activeChar.sendPacket(smA);
        }
        this.showSkillsPage(activeChar);
    }

    private void adminResetSkills(L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        if (adminSkills == null) {
            SystemMessage smA = new SystemMessage(614);
            smA.addString("You must first get the skills of someone to do this.");
            activeChar.sendPacket(smA);
        } else {
            int i;
            L2Skill[] skills = player.getAllSkills();
            for (i = 0; i < skills.length; ++i) {
                player.removeSkill(skills[i]);
            }
            for (i = 0; i < activeChar.getAllSkills().length; ++i) {
                player.addSkill(activeChar.getAllSkills()[i]);
            }
            for (i = 0; i < skills.length; ++i) {
                activeChar.removeSkill(skills[i]);
            }
            for (i = 0; i < adminSkills.length; ++i) {
                activeChar.addSkill(adminSkills[i]);
            }
            SystemMessage sm = new SystemMessage(614);
            sm.addString("[GM]" + activeChar.getName() + " has updated your skills.");
            player.sendPacket(sm);
            SystemMessage smA = new SystemMessage(614);
            smA.addString("You now have all your skills back.");
            activeChar.sendPacket(smA);
            adminSkills = null;
        }
        this.showSkillsPage(activeChar);
    }

    private void adminAddSkill(L2PcInstance activeChar, String val) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        StringTokenizer st = new StringTokenizer(val);
        if (st.countTokens() != 2) {
            this.showSkillsPage(activeChar);
        } else {
            String id = st.nextToken();
            String level = st.nextToken();
            int idval = Integer.parseInt(id);
            int levelval = Integer.parseInt(level);
            L2Skill skill = SkillTable.getInstance().getInfo(idval, levelval);
            if (skill != null) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Admin gave you the skill " + skill.getName() + ".");
                player.sendPacket(sm);
                player.addSkill(skill);
                SystemMessage smA = new SystemMessage(614);
                smA.addString("You gave the skill " + skill.getName() + " to " + player.getName() + ".");
                activeChar.sendPacket(smA);
                if (Config.DEBUG) {
                    _log.fine("[GM]" + activeChar.getName() + "gave the skill " + skill.getName() + " to " + player.getName() + ".");
                }
            } else {
                SystemMessage smA = new SystemMessage(614);
                smA.addString("Error: there is no such skill.");
            }
            this.showSkillsPage(activeChar);
        }
    }

    private void adminRemoveSkill(L2PcInstance activeChar, int idval) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        L2Skill skill = SkillTable.getInstance().getInfo(idval, player.getSkillLevel(idval));
        if (skill != null) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Admin removed the skill " + skill.getName() + ".");
            player.sendPacket(sm);
            player.removeSkill(skill);
            SystemMessage smA = new SystemMessage(614);
            smA.addString("You removed the skill " + skill.getName() + " from " + player.getName() + ".");
            activeChar.sendPacket(smA);
            if (Config.DEBUG) {
                _log.fine("[GM]" + activeChar.getName() + "removed the skill " + skill.getName() + " from " + player.getName() + ".");
            }
        } else {
            SystemMessage smA = new SystemMessage(614);
            smA.addString("Error: there is no such skill.");
        }
        this.removeSkillsPage(activeChar);
    }

    public void showSkill(L2PcInstance activeChar, String val) {
        int skillid = Integer.parseInt(val);
        L2Skill skill = SkillTable.getInstance().getInfo(skillid, 1);
        if (skill != null) {
            if (skill.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF) {
                activeChar.setTarget(activeChar);
                MagicSkillUser msk = new MagicSkillUser(activeChar, skillid, 1, skill.getSkillTime(), skill.getReuseDelay());
                activeChar.broadcastPacket(msk);
                if (Config.DEBUG) {
                    _log.fine("showing self skill, id: " + skill.getId() + " named: " + skill.getName());
                }
            } else if (skill.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE && Config.DEBUG) {
                _log.fine("showing ATTACK skill, id: " + skill.getId() + " named: " + skill.getName());
            }
        } else {
            if (Config.DEBUG) {
                _log.fine("no such skill id: " + skillid);
            }
            ActionFailed af = new ActionFailed();
            activeChar.broadcastPacket(af);
        }
    }
}

