/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.Announcements;
import net.sf.l2j.gameserver.CastleUpdater;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.DoorTable;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Siege;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.StopMove;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminSeige
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminSeige.class.getName());
    private static String[] _adminCommands = new String[]{"admin_setcastle", "admin_clean_up_siege", "admin_spawn_doors", "admin_move_defenders", "admin_startsiege", "admin_endsiege", "admin_list_siege_clans", "admin_add_defender", "admin_add_attacker", "admin_clear_siege_list", "admin_siege"};
    private static final int REQUIRED_LEVEL = Config.GM_NPC_EDIT;
    private static final int GLUDIO = 1;
    private static final int GIRAN = 2;
    private static final int DION = 3;
    private static final int OREN = 4;
    private static final int ADEN = 5;
    private static final String[] castleNames = new String[]{"Nowhere", "Gludio", "Giran", "Dion", "Oren", "Aden"};

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.startsWith("admin_setcastle")) {
            String castle2 = command.substring(16);
            int castleNum = this.castleNum(castle2);
            if (!(target instanceof L2PcInstance)) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Incorrect target.");
                activeChar.sendPacket(sm);
                return false;
            }
            player = (L2PcInstance)target;
            L2Clan playersClan = player.getClan();
            if (playersClan != null) {
                int previousCastle = playersClan.getHasCastle();
                playersClan.setHasCastle(castleNum);
                Announcements anounce = new Announcements();
                if (castleNum == 0 && previousCastle != 0) {
                    anounce.announceToAll(playersClan.getName() + " has lost " + castleNames[previousCastle] + " castle!");
                } else if (castleNum != 0) {
                    anounce.announceToAll(playersClan.getName() + " has taken " + castleNames[castleNum] + " castle!");
                    L2Siege.setCastleOwner(playersClan.getClanId());
                }
                CastleUpdater cu = new CastleUpdater(playersClan);
                ClientScheduler.getInstance().scheduleLow(cu, 30000L);
            }
        } else if (command.equals("admin_add_defender")) {
            if (!(target instanceof L2PcInstance)) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Incorrect target.");
                activeChar.sendPacket(sm);
                return false;
            }
            player = (L2PcInstance)target;
            L2Clan playersClan = player.getClan();
            if (playersClan != null) {
                L2Siege.addDefender(playersClan);
                Announcements anounce = new Announcements();
                anounce.announceToAll(playersClan.getName() + " Has been registered as a defending Clan");
            }
        } else if (command.startsWith("admin_add_defender")) {
            String castle3 = command.substring(19);
            int castleNum = this.castleNum(castle3);
            if (!(target instanceof L2PcInstance)) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Incorrect target.");
                activeChar.sendPacket(sm);
                return false;
            }
            player = (L2PcInstance)target;
            L2Siege.storeSiegeClan(player.getClanId(), castleNum, 0);
        } else if (command.equals("admin_add_attacker")) {
            if (!(target instanceof L2PcInstance)) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Incorrect target.");
                activeChar.sendPacket(sm);
                return false;
            }
            player = (L2PcInstance)target;
            L2Clan playersClan = player.getClan();
            if (playersClan != null) {
                L2Siege.addAttacker(playersClan);
                Announcements anounce = new Announcements();
                anounce.announceToAll(playersClan.getName() + " Has been registered as an attacking Clan");
            }
        } else if (command.startsWith("admin_add_attacker")) {
            String castle4 = command.substring(19);
            int castleNum = this.castleNum(castle4);
            if (!(target instanceof L2PcInstance)) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Incorrect target.");
                activeChar.sendPacket(sm);
                return false;
            }
            player = (L2PcInstance)target;
            L2Siege.storeSiegeClan(player.getClanId(), castleNum, 1);
        } else if (command.equals("admin_list_siege_clans")) {
            int i;
            L2Clan[] attackers = L2Siege.getAttackers();
            L2Clan[] defenders = L2Siege.getDefenders();
            int numAttackers = L2Siege.getNumAttackers();
            int numDefenders = L2Siege.getNumDefenders();
            Announcements anounce = new Announcements();
            anounce.announceToAll("Attacking Clans:");
            for (i = 0; i < numAttackers; ++i) {
                String attacker = attackers[i].getName();
                anounce.announceToAll(attacker);
            }
            anounce.announceToAll("Defending Clans:");
            for (i = 0; i < numDefenders; ++i) {
                String defender = defenders[i].getName();
                anounce.announceToAll(defender);
            }
        } else if (command.startsWith("admin_startsiege")) {
            String castle5 = command.substring(17);
            int castleNum = this.castleNum(castle5);
            L2Siege.setSiege(castleNum);
            Announcements anounce = new Announcements();
            if (castleNum != 0) {
                anounce.announceToAll("The Siege of " + castleNames[castleNum] + " has begun!");
            } else {
                anounce.announceToAll("The Siege has ended!");
            }
        } else if (command.equals("admin_endsiege")) {
            L2Siege.setSiege(0);
            Announcements anounce = new Announcements();
            anounce.announceToAll("The Siege has ended!");
        } else if (command.equals("admin_clear_siege_list")) {
            L2Siege.clearList();
        } else if (command.equals("admin_move_defenders")) {
            int theCastle = L2Siege.getSiege() - 1;
            if (theCastle > -1) {
                for (L2PcInstance _player : L2World.getInstance().getAllPlayers()) {
                    if (!L2Siege.isDefender(_player.getClanId())) continue;
                    StopMove sm = new StopMove(_player);
                    _player.sendPacket(sm);
                    _player.broadcastPacket(sm);
                    ActionFailed af = new ActionFailed();
                    _player.sendPacket(af);
                    _player.teleToLocation(L2World.castlespawns[theCastle * 2 + 1][0], L2World.castlespawns[theCastle * 2 + 1][1], L2World.castlespawns[theCastle * 2 + 1][2]);
                }
            }
        } else if (command.startsWith("admin_move_defenders")) {
            String castle6 = command.substring(21);
            int castleNum = this.castleNum(castle6);
            int theCastle = castleNum - 1;
            if (theCastle > -1) {
                for (L2PcInstance _player : L2World.getInstance().getAllPlayers()) {
                    if (!L2Siege.isDefender(_player.getClanId())) continue;
                    StopMove sm = new StopMove(_player);
                    _player.sendPacket(sm);
                    _player.broadcastPacket(sm);
                    ActionFailed af = new ActionFailed();
                    _player.sendPacket(af);
                    _player.teleToLocation(L2World.castlespawns[theCastle * 2 + 1][0], L2World.castlespawns[theCastle * 2 + 1][1], L2World.castlespawns[theCastle * 2 + 1][2]);
                }
            }
        } else if (command.equals("admin_spawn_doors")) {
            DoorTable doors = DoorTable.getInstance();
            doors.respawn();
        } else if (command.equals("admin_clean_up_siege")) {
            L2Siege.endSiege();
        }
        this.showSiegePage(activeChar);
        return true;
    }

    private int castleNum(String name) {
        int castleNum = 0;
        if (name.equals("gludio")) {
            castleNum = 1;
        } else if (name.equals("giran")) {
            castleNum = 2;
        } else if (name.equals("dion")) {
            castleNum = 3;
        } else if (name.equals("oren")) {
            castleNum = 4;
        } else if (name.equals("aden")) {
            castleNum = 5;
        } else if (name.equals("0")) {
            castleNum = 0;
        }
        return castleNum;
    }

    public void showSiegePage(L2PcInstance activeChar) {
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Siege Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br><center>Castle names: gludio, giran, dion, oren</center><br><br>");
        replyMSG.append("<center><table> <tr><td> Castle Name:<edit var=\"urlid\" width=80>");
        replyMSG.append("<button value=\"Start Siege\" action=\"bypass -h admin_startsiege $urlid\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<button value=\"Give Castle\" action=\"bypass -h admin_setcastle $urlid\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<button value=\"Move Defenders\" action=\"bypass -h admin_move_defenders $urlid\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<button value=\"Add Defender\" action=\"bypass -h admin_add_defender $urlid\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<button value=\"Add Attacker\" action=\"bypass -h admin_add_attacker $urlid\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("<br></td></tr>");
        replyMSG.append("</table></center>");
        replyMSG.append("<center><table>");
        replyMSG.append("<tr><td><button value=\"Add Attacker\" action=\"bypass -h admin_add_attacker\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"List Clans\" action=\"bypass -h admin_list_siege_clans\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("<tr><td><button value=\"Add Defender\" action=\"bypass -h admin_add_defender\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"Clear List\" action=\"bypass -h admin_clear_siege_list\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("<tr><td><button value=\"Move Defenders\" action=\"bypass -h admin_move_defenders\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td><button value=\"End Siege\" action=\"bypass -h admin_clean_up_siege\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td></tr>");
        replyMSG.append("</table></center>");
        replyMSG.append("<center><table>");
        replyMSG.append("<tr><td><br><button value=\"Spawn Doors\" action=\"bypass -h admin_spawn_doors\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\">");
        replyMSG.append("</td></tr></table></center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }
}

