/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientScheduler;
import net.sf.l2j.gameserver.MonsterRace;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.DeleteObject;
import net.sf.l2j.gameserver.serverpackets.MonRaceInfo;
import net.sf.l2j.gameserver.serverpackets.PlaySound;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminMonsterRace
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminMonsterRace.class.getName());
    private static String[] _adminCommands = new String[]{"admin_mons"};
    private static final int REQUIRED_LEVEL = Config.GM_MONSTERRACE;
    protected static int state = -1;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        this.handleSendPacket(command, activeChar);
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void handleSendPacket(String command, L2PcInstance activeChar) {
        int[][] codes = new int[][]{{-1, 0}, {0, 15322}, {13765, -1}, {-1, 0}};
        MonsterRace race = MonsterRace.getInstance();
        if (state == -1) {
            race.newRace();
            race.newSpeeds();
            MonRaceInfo spk = new MonRaceInfo(codes[++state][0], codes[state][1], race.getMonsters(), race.getSpeeds());
            activeChar.sendPacket(spk);
            activeChar.broadcastPacket(spk);
        } else if (state == 0) {
            ++state;
            SystemMessage sm = new SystemMessage(824);
            sm.addNumber(0);
            activeChar.sendPacket(sm);
            PlaySound SRace = new PlaySound(1, "S_Race", 0, 0, 0, 0, 0);
            activeChar.sendPacket(SRace);
            activeChar.broadcastPacket(SRace);
            PlaySound SRace2 = new PlaySound(0, "ItemSound2.race_start", 1, 121209259, 12125, 182487, -3559);
            activeChar.sendPacket(SRace2);
            activeChar.broadcastPacket(SRace2);
            MonRaceInfo spk = new MonRaceInfo(codes[state][0], codes[state][1], race.getMonsters(), race.getSpeeds());
            activeChar.sendPacket(spk);
            activeChar.broadcastPacket(spk);
            ClientScheduler.getInstance().scheduleMed(new RunRace(codes, activeChar), 5000L);
        }
    }

    class RunEnd
    implements Runnable {
        private int[][] codes;
        private L2PcInstance activeChar;

        public RunEnd(L2PcInstance activeChar) {
            this.activeChar = activeChar;
        }

        public void run() {
            DeleteObject obj = null;
            for (int i = 0; i < 8; ++i) {
                obj = new DeleteObject(MonsterRace.getInstance().getMonsters()[i]);
                this.activeChar.sendPacket(obj);
                this.activeChar.broadcastPacket(obj);
            }
            state = -1;
        }
    }

    class RunRace
    implements Runnable {
        private int[][] codes;
        private L2PcInstance activeChar;

        public RunRace(int[][] codes, L2PcInstance activeChar) {
            this.codes = codes;
            this.activeChar = activeChar;
        }

        public void run() {
            MonRaceInfo spk = new MonRaceInfo(this.codes[2][0], this.codes[2][1], MonsterRace.getInstance().getMonsters(), MonsterRace.getInstance().getSpeeds());
            this.activeChar.sendPacket(spk);
            this.activeChar.broadcastPacket(spk);
            ClientScheduler.getInstance().scheduleMed(new RunEnd(this.activeChar), 30000L);
        }
    }
}

