/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.io.File;
import java.io.FileInputStream;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;

public class AdminHelpPage
implements IAdminCommandHandler {
    private static String[] _adminCommands = new String[]{"admin_help"};
    private static final int REQUIRED_LEVEL = Config.GM_MIN;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel())) {
            return false;
        }
        if (command.startsWith("admin_help")) {
            try {
                String val = command.substring(11);
                AdminHelpPage.showHelpPage(activeChar, val);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showHelpPage(L2PcInstance targetChar, String filename) {
        File file = new File(Config.DATAPACK_ROOT, "data/html/admin/" + filename);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] raw = new byte[fis.available()];
            fis.read(raw);
            String content = new String(raw, "UTF-8");
            NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
            adminReply.setHtml(content);
            targetChar.sendPacket(adminReply);
        }
        catch (Exception e) {
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e1) {}
        }
    }
}

