/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.Experience;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminExpSp
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminExpSp.class.getName());
    private static String[] _adminCommands = new String[]{"admin_add_exp_sp_to_character", "admin_add_exp_sp"};
    private static final int REQUIRED_LEVEL = Config.GM_CHAR_EDIT;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.equals("admin_add_exp_sp_to_character")) {
            this.addExpSp(activeChar);
        } else if (command.startsWith("admin_add_exp_sp")) {
            try {
                String val = command.substring(16);
                this.adminAddExpSp(activeChar, val);
            }
            catch (StringIndexOutOfBoundsException e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Error while adding Exp-Sp.");
                activeChar.sendPacket(sm);
            }
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void addExpSp(L2PcInstance activeChar) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Character Selection Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_current_player\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        replyMSG.append("<table width=270><tr><td>Name: " + player.getName() + "</td></tr>");
        replyMSG.append("<tr><td>Lv: " + player.getLevel() + " " + player.getTemplate().className + "</td></tr>");
        replyMSG.append("<tr><td>Exp: " + player.getExp() + "</td></tr>");
        replyMSG.append("<tr><td>Sp: " + player.getSp() + "</td></tr></table>");
        replyMSG.append("<br><table width=270><tr><td>Note: Dont forget that modifying players skills can</td></tr>");
        replyMSG.append("<tr><td>ruin the game...</td></tr></table><br>");
        replyMSG.append("<table width=270><tr><td>Note: Fill all values before saving the modifications.,</td></tr>");
        replyMSG.append("<tr><td>Note: Use 0 if no changes are needed.</td></tr></table><br>");
        replyMSG.append("<center><table><tr>");
        replyMSG.append("<td>Exp: <edit var=\"exp_to_add\" width=50></td>");
        replyMSG.append("<td>Sp:  <edit var=\"sp_to_add\" width=50></td>");
        replyMSG.append("<td>&nbsp;<button value=\"Save Changes\" action=\"bypass -h admin_add_exp_sp $exp_to_add $sp_to_add\" width=80 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table></center>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    private void adminAddExpSp(L2PcInstance activeChar, String ExpSp) {
        L2Object target = activeChar.getTarget();
        L2PcInstance player = null;
        if (!(target instanceof L2PcInstance)) {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
            return;
        }
        player = (L2PcInstance)target;
        StringTokenizer st = new StringTokenizer(ExpSp);
        if (st.countTokens() != 2) {
            this.addExpSp(player);
        } else {
            String exp = st.nextToken();
            String sp = st.nextToken();
            int expval = Integer.parseInt(exp);
            int spval = Integer.parseInt(sp);
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Admin is adding you " + expval + " xp and " + spval + " sp.");
            player.sendPacket(sm);
            int lvl = player.getLevel();
            player.addExpAndSp(expval, spval);
            while (player.getExp() < Experience.LEVEL[lvl] && lvl > 1) {
                player.decreaseLevel();
                lvl = player.getLevel();
            }
            SystemMessage smA = new SystemMessage(614);
            smA.addString("Added " + expval + " xp and " + spval + " sp to " + player.getName() + ".");
            activeChar.sendPacket(smA);
            if (Config.DEBUG) {
                _log.fine("GM: " + activeChar.getObjectId() + " added " + expval + " xp and " + spval + " sp to " + player.getObjectId() + ".");
            }
        }
    }
}

