/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminDelete;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.CharInfo;
import net.sf.l2j.gameserver.serverpackets.Earthquake;
import net.sf.l2j.gameserver.serverpackets.NpcInfo;
import net.sf.l2j.gameserver.serverpackets.ServerBasePacket;
import net.sf.l2j.gameserver.serverpackets.StopMove;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.serverpackets.UserInfo;

public class AdminEffects
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminDelete.class.getName());
    private static String[] _adminCommands = new String[]{"admin_invis", "admin_invisible", "admin_vis", "admin_visible", "admin_earthquake", "admin_bighead", "admin_shrinkhead", "admin_unpara_all", "admin_para_all", "admin_unpara", "admin_para", "admin_polyself", "admin_unpolyself", "admin_changename"};
    private static final int REQUIRED_LEVEL = Config.GM_GODMODE;

    /*
     * WARNING - void declaration
     */
    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        L2Object target;
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.equals("admin_invis") || command.equals("admin_invisible")) {
            activeChar.setInvisible();
            activeChar.broadcastUserInfo();
            activeChar.teleToLocation(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        }
        if (command.equals("admin_vis") || command.equals("admin_visible")) {
            activeChar.setVisible();
            activeChar.broadcastUserInfo();
        }
        if (command.startsWith("admin_earthquake")) {
            try {
                String val = command.substring(17);
                StringTokenizer stringTokenizer = new StringTokenizer(val);
                String val1 = stringTokenizer.nextToken();
                int intensity = Integer.parseInt(val1);
                String val2 = stringTokenizer.nextToken();
                int duration = Integer.parseInt(val2);
                Earthquake eq2 = new Earthquake(activeChar.getX(), activeChar.getY(), activeChar.getZ(), intensity, duration);
                activeChar.broadcastPacket(eq2);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (command.equals("admin_para")) {
            String type = "1";
            StringTokenizer stringTokenizer = new StringTokenizer(command);
            try {
                stringTokenizer.nextToken();
                type = stringTokenizer.nextToken();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                target = activeChar.getTarget();
                L2Character player = null;
                if (target instanceof L2Character) {
                    player = (L2Character)target;
                    if (type.equals("1")) {
                        player.startAbnormalEffect((short)1024);
                    } else {
                        player.startAbnormalEffect((short)2048);
                    }
                    player.setParalyzed(true);
                    StopMove sm = new StopMove(player);
                    player.sendPacket(sm);
                    player.broadcastPacket(sm);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (command.equals("admin_unpara")) {
            try {
                L2Object target2 = activeChar.getTarget();
                Object var4_13 = null;
                if (target2 instanceof L2Character) {
                    L2Character l2Character = (L2Character)target2;
                    l2Character.stopAbnormalEffect((short)1024);
                    l2Character.setParalyzed(false);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (command.startsWith("admin_para_all")) {
            try {
                for (L2PcInstance l2PcInstance : activeChar.getKnownPlayers()) {
                    if (l2PcInstance.isGM()) continue;
                    l2PcInstance.startAbnormalEffect((short)1024);
                    l2PcInstance.setParalyzed(true);
                    StopMove sm = new StopMove(l2PcInstance);
                    l2PcInstance.sendPacket(sm);
                    l2PcInstance.broadcastPacket(sm);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (command.startsWith("admin_unpara_all")) {
            try {
                for (L2PcInstance l2PcInstance : activeChar.getKnownPlayers()) {
                    l2PcInstance.stopAbnormalEffect((short)1024);
                    l2PcInstance.setParalyzed(false);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (command.startsWith("admin_bighead")) {
            try {
                activeChar.startAbnormalEffect((short)8192);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (command.startsWith("admin_shrinkhead")) {
            try {
                activeChar.stopAbnormalEffect((short)8192);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (command.startsWith("admin_polyself")) {
            StringTokenizer st2 = new StringTokenizer(command);
            try {
                st2.nextToken();
                String string = st2.nextToken();
                activeChar.setPolyInfo("npc", string);
                activeChar.teleToLocation(activeChar.getX(), activeChar.getY(), activeChar.getZ());
                CharInfo info1 = new CharInfo(activeChar);
                activeChar.broadcastPacket(info1);
                UserInfo info2 = new UserInfo(activeChar);
                activeChar.sendPacket(info2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (command.startsWith("admin_unpolyself")) {
            activeChar.setPolyInfo(null, "1");
            activeChar.decayMe();
            activeChar.spawnMe(activeChar.getX(), activeChar.getY(), activeChar.getZ());
            CharInfo info1 = new CharInfo(activeChar);
            activeChar.broadcastPacket(info1);
            UserInfo userInfo = new UserInfo(activeChar);
            activeChar.sendPacket(userInfo);
        }
        if (command.startsWith("admin_changename")) {
            String name = command.substring(17);
            String string = "null";
            try {
                void var4_29;
                ServerBasePacket info1;
                target = activeChar.getTarget();
                L2Character player = null;
                if (target instanceof L2Character) {
                    player = (L2Character)target;
                    String string2 = player.getName();
                } else if (target == null) {
                    player = activeChar;
                    String string3 = activeChar.getName();
                }
                if (player instanceof L2PcInstance) {
                    L2World.getInstance().removeFromAllPlayers((L2PcInstance)player);
                }
                player.setName(name);
                if (player instanceof L2PcInstance) {
                    L2World.getInstance().addVisibleObject(player, null, null);
                }
                if (player instanceof L2PcInstance) {
                    info1 = new CharInfo((L2PcInstance)player);
                    player.broadcastPacket(info1);
                    UserInfo info2 = new UserInfo((L2PcInstance)player);
                    player.sendPacket(info2);
                } else if (player instanceof L2NpcInstance) {
                    info1 = new NpcInfo((L2NpcInstance)player, null);
                    player.broadcastPacket(info1);
                }
                SystemMessage smA = new SystemMessage(614);
                smA.addString("Changed name from " + (String)var4_29 + " to " + name + ".");
                activeChar.sendPacket(smA);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }
}

