/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.DoorTable;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;

public class AdminDoorControl
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminDoorControl.class.getName());
    private static final int REQUIRED_LEVEL = Config.GM_DOOR;
    private static DoorTable _doorTable;
    private static String[] _adminCommands;
    private static final Map<String, Integer> doorMap;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        _doorTable = DoorTable.getInstance();
        try {
            L2Object target;
            String doorName;
            if (command.startsWith("admin_open ")) {
                doorName = command.split(" ")[1];
                _doorTable.getDoor(doorMap.get(doorName)).openMe();
            } else if (command.equals("admin_close ")) {
                doorName = command.split(" ")[1];
                _doorTable.getDoor(doorMap.get(doorName)).closeMe();
            }
            if (command.equals("admin_closeall")) {
                for (Integer doorID : doorMap.values()) {
                    _doorTable.getDoor(doorID).closeMe();
                }
            }
            if (command.equals("admin_openall")) {
                for (Integer doorID : doorMap.values()) {
                    _doorTable.getDoor(doorID).openMe();
                }
            }
            if (command.equals("admin_open")) {
                target = activeChar.getTarget();
                if (target instanceof L2DoorInstance) {
                    ((L2DoorInstance)target).openMe();
                } else {
                    activeChar.sendMessage("Incorrect target.");
                }
            }
            if (command.equals("admin_close")) {
                target = activeChar.getTarget();
                if (target instanceof L2DoorInstance) {
                    ((L2DoorInstance)target).closeMe();
                } else {
                    activeChar.sendMessage("Incorrect target.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    static {
        _adminCommands = new String[]{"admin_open", "admin_close"};
        doorMap = new HashMap<String, Integer>();
        doorMap.put("1", 24190001);
        doorMap.put("2", 24190002);
        doorMap.put("3", 24190003);
        doorMap.put("4", 24190004);
    }
}

