/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.SpawnTable;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2NpcInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminDelete
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminDelete.class.getName());
    private static String[] _adminCommands = new String[]{"admin_delete"};
    private static final int REQUIRED_LEVEL = Config.GM_NPC_EDIT;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.equals("admin_delete")) {
            this.handleDelete(activeChar);
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void handleDelete(L2PcInstance activeChar) {
        L2Object obj = activeChar.getTarget();
        if (obj != null && obj instanceof L2NpcInstance) {
            L2NpcInstance target = (L2NpcInstance)obj;
            target.deleteMe();
            L2Spawn spawn = target.getSpawn();
            if (spawn != null) {
                spawn.stopRespawn();
                SpawnTable.getInstance().deleteSpawn(spawn, true);
            }
            if (Config.DEBUG) {
                _log.fine("GM: Admin id " + activeChar.getObjectId() + " deleted NPC" + target.getObjectId());
            }
        } else {
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Incorrect target.");
            activeChar.sendPacket(sm);
        }
    }
}

