/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.StringTokenizer;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminHelpPage;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.NpcHtmlMessage;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminCreateItem
implements IAdminCommandHandler {
    private static String[] _adminCommands = new String[]{"admin_itemcreate", "admin_create_item"};
    private static final int REQUIRED_LEVEL = Config.GM_CREATE_ITEM;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        if (command.equals("admin_itemcreate")) {
            AdminHelpPage.showHelpPage(activeChar, "itemcreation.htm");
        } else if (command.startsWith("admin_create_item")) {
            try {
                String val = command.substring(17);
                StringTokenizer st = new StringTokenizer(val);
                if (st.countTokens() == 2) {
                    String id = st.nextToken();
                    int idval = Integer.parseInt(id);
                    String num = st.nextToken();
                    int numval = Integer.parseInt(num);
                    this.createItem(activeChar, idval, numval);
                } else if (st.countTokens() == 1) {
                    String id = st.nextToken();
                    int idval = Integer.parseInt(id);
                    this.createItem(activeChar, idval, 1);
                } else {
                    AdminHelpPage.showHelpPage(activeChar, "itemcreation.htm");
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("Error while creating item.");
                activeChar.sendPacket(sm);
            }
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void createItem(L2PcInstance activeChar, int id, int num) {
        L2ItemInstance createditem = ItemTable.getInstance().createItem(id);
        if (!createditem.isStackable()) {
            for (int i = 0; i < num; ++i) {
                activeChar.getInventory().addItem(createditem);
                createditem = ItemTable.getInstance().createItem(id);
            }
        } else {
            createditem.setCount(createditem.getCount() + (num - 1));
            activeChar.getInventory().addItem(createditem);
        }
        ItemList il = new ItemList(activeChar, true);
        activeChar.sendPacket(il);
        SystemMessage sm = new SystemMessage(614);
        sm.addString("You have spawned " + num + " item(s) number " + id + " in your inventory.");
        activeChar.sendPacket(sm);
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        StringBuffer replyMSG = new StringBuffer("<html><body>");
        replyMSG.append("<table width=260><tr>");
        replyMSG.append("<td width=40><button value=\"Main\" action=\"bypass -h admin_admin\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("<td width=180><center>Item Creation Menu</center></td>");
        replyMSG.append("<td width=40><button value=\"Back\" action=\"bypass -h admin_help itemcreation.htm\" width=40 height=15 back=\"sek.cbui94\" fore=\"sek.cbui92\"></td>");
        replyMSG.append("</tr></table>");
        replyMSG.append("<br><br>");
        replyMSG.append("<table width=270><tr><td>Item Creation Complete.<br></td></tr></table>");
        replyMSG.append("<table width=270><tr><td>You have spawned " + num + " item(s) number " + id + " in your inventory.</td></tr></table>");
        replyMSG.append("</body></html>");
        adminReply.setHtml(replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }
}

