/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;

public class AdminChangeAccessLevel
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminChangeAccessLevel.class.getName());
    private static String[] _adminCommands = new String[]{"admin_changelvl"};
    private static final int REQUIRED_LEVEL = Config.GM_ACCESSLEVEL;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (!this.checkLevel(activeChar.getAccessLevel()) || !activeChar.isGM()) {
            return false;
        }
        this.handleChangeLevel(command, activeChar);
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    private void handleChangeLevel(String command, L2PcInstance admin) {
        String[] parts = command.split(" ");
        if (parts.length == 2) {
            int lvl = Integer.parseInt(parts[1]);
            if (admin.getTarget() instanceof L2PcInstance) {
                ((L2PcInstance)admin.getTarget()).setAccessLevel(lvl);
            }
        } else if (parts.length == 3) {
            int lvl = Integer.parseInt(parts[2]);
            L2PcInstance player = L2World.getInstance().getPlayer(parts[1]);
            if (player != null) {
                player.setAccessLevel(lvl);
            }
        }
    }
}

