/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler.admincommandhandlers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.handler.admincommandhandlers.AdminBan;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class AdminBanChat
implements IAdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminBan.class.getName());
    private static String[] _adminCommands = new String[]{"admin_banchat", "admin_unbanchat"};
    private static final int REQUIRED_LEVEL = Config.GM_BAN;

    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        StringTokenizer st;
        if (!this.checkLevel(activeChar.getAccessLevel())) {
            System.out.println("Not required level");
            return false;
        }
        if (command.startsWith("admin_banchat")) {
            StringTokenizer st2 = new StringTokenizer(command);
            if (st2.countTokens() > 1) {
                st2.nextToken();
                String player = st2.nextToken();
                L2PcInstance plyr = L2World.getInstance().getPlayer(player);
                if (plyr != null) {
                    plyr.logout();
                }
                this.setCharacterAccessLevel(player, activeChar, -1);
            }
        } else if (command.startsWith("admin_unbanchat") && (st = new StringTokenizer(command)).countTokens() > 1) {
            st.nextToken();
            String player = st.nextToken();
            this.setCharacterAccessLevel(player, activeChar, 0);
        }
        return true;
    }

    public String[] getAdminCommandList() {
        return _adminCommands;
    }

    private boolean checkLevel(int level) {
        return level >= REQUIRED_LEVEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCharacterAccessLevel(String user2, L2PcInstance player, int banLevel) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            String stmt = "UPDATE characters SET characters.accesslevel = ? WHERE characters.char_name=?";
            PreparedStatement statement = con.prepareStatement(stmt);
            statement.setInt(1, banLevel);
            statement.setString(2, user2);
            statement.executeUpdate();
            statement.close();
            SystemMessage sm = new SystemMessage(614);
            sm.addString("Character Access Level for " + user2 + " set to " + banLevel + ".");
            player.sendPacket(sm);
        }
        catch (Exception e) {
            _log.warning("Could not set accessLevl:" + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }
}

