/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.handler.IVoicedCommandHandler;
import net.sf.l2j.gameserver.handler.ItemHandler;

public class VoicedCommandHandler {
    private static Logger _log = Logger.getLogger(ItemHandler.class.getName());
    private static VoicedCommandHandler _instance;
    private Map<String, IVoicedCommandHandler> _datatable = new HashMap<String, IVoicedCommandHandler>();

    public static VoicedCommandHandler getInstance() {
        if (_instance == null) {
            _instance = new VoicedCommandHandler();
        }
        return _instance;
    }

    private VoicedCommandHandler() {
    }

    public void registerVoicedCommandHandler(IVoicedCommandHandler handler) {
        String[] ids = handler.getVoicedCommandList();
        for (int i = 0; i < ids.length; ++i) {
            if (Config.DEBUG) {
                _log.fine("Adding handler for command " + ids[i]);
            }
            this._datatable.put(new String(ids[i]), handler);
        }
    }

    public IVoicedCommandHandler getVoicedCommandHandler(String voicedCommand) {
        String command = voicedCommand;
        if (voicedCommand.indexOf(" ") != -1) {
            command = voicedCommand.substring(0, voicedCommand.indexOf(" "));
        }
        if (Config.DEBUG) {
            _log.fine("getting handler for command: " + command + " -> " + (this._datatable.get(new String(command)) != null));
        }
        return this._datatable.get(command);
    }

    public int size() {
        return this._datatable.size();
    }
}

