/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.Universe;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ValidateLocation;

public class ValidatePosition
extends ClientBasePacket {
    private static Logger _log = Logger.getLogger(ValidatePosition.class.getName());
    private static final String _C__48_VALIDATEPOSITION = "[C] 48 ValidatePosition";
    private final int _x = this.readD();
    private final int _y = this.readD();
    private final int _z = this.readD();
    private final int _heading = this.readD();
    private final int _data = this.readD();

    public ValidatePosition(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        if (activeChar != null) {
            int dy;
            int dx;
            int diff2;
            int realX = activeChar.getX();
            int realY = activeChar.getY();
            int realZ = activeChar.getZ();
            int realHeading = activeChar.getHeading();
            if (Config.DEBUG) {
                _log.fine("client pos: " + this._x + " " + this._y + " " + this._z + " head " + this._heading);
                _log.fine("server pos: " + realX + " " + realY + " " + realZ + " head " + realHeading);
            }
            if (Config.ACTIVATE_POSITION_RECORDER && Universe.getInstance().shouldLog(activeChar.getObjectId())) {
                Universe.getInstance().registerHeight(realX, realY, this._z);
            }
            if (Config.DEVELOPER && (diff2 = (dx = this._x - realX) * dx + (dy = this._y - realY) * dy) > 1000000) {
                if (Config.DEBUG) {
                    _log.fine("client/server dist diff " + (int)Math.sqrt(diff2));
                }
                this.sendPacket(new ValidateLocation(activeChar));
            }
            activeChar.updateKnownObjects();
        }
    }

    private long distance(L2Object a, L2Object b) {
        long dX = a.getX() - b.getX();
        long dY = a.getY() - b.getY();
        return dX * dX + dY * dY;
    }

    public String getType() {
        return _C__48_VALIDATEPOSITION;
    }
}

