/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.ChangeWaitType;

public class SendPrivateStoreBuyBuyList
extends ClientBasePacket {
    private static final String _C__96_SENDPRIVATESTOREBUYBUYLIST = "[C] 96 SendPrivateStoreBuyBuyList";
    private static Logger _log = Logger.getLogger(SendPrivateStoreBuyBuyList.class.getName());
    private final int _buyerID = this.readD();
    private final int _count = this.readD();
    private final int[] _items = new int[this._count * 4];

    public SendPrivateStoreBuyBuyList(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        for (int i = 0; i < this._count; ++i) {
            int price;
            int cnt;
            int itemId;
            int objectId;
            this._items[i * 4 + 0] = objectId = this.readD();
            this._items[i * 4 + 1] = itemId = this.readD();
            this.readH();
            this._items[i * 4 + 2] = cnt = this.readD();
            this._items[i * 4 + 3] = price = this.readD();
        }
    }

    void runImpl() {
        L2World world = L2World.getInstance();
        L2PcInstance seller = this.getClient().getActiveChar();
        L2PcInstance buyer = (L2PcInstance)world.findObject(this._buyerID);
        ArrayList<TradeItem> buyerlist = buyer.getBuyList();
        ArrayList<TradeItem> sellerlist = new ArrayList<TradeItem>();
        int cost = 0;
        for (int i = 0; i < this._count; ++i) {
            TradeItem temp = new TradeItem();
            int objectId = this._items[i * 4 + 0];
            int itemId = this._items[i * 4 + 1];
            int cnt = this._items[i * 4 + 2];
            int price = this._items[i * 4 + 3];
            temp.setObjectId(objectId);
            temp.setItemId(itemId);
            temp.setCount(cnt);
            temp.setOwnersPrice(price);
            cost += temp.getOwnersPrice() * temp.getCount();
            sellerlist.add(temp);
        }
        if (buyer.getAdena() >= cost && this._count > 0 && buyer.getPrivateStoreType() == 3) {
            buyer.getTradeList().BuySellItems(buyer, buyerlist, seller, sellerlist);
            buyer.getTradeList().updateBuyList(buyer, buyerlist);
            if (buyer.getBuyList().size() == 0) {
                buyer.setPrivateStoreType(0);
                buyer.sendPacket(new ChangeWaitType(buyer, true));
                buyer.broadcastPacket(new ChangeWaitType(buyer, true));
                buyer.broadcastUserInfo();
            }
        } else {
            buyer.getTradeList().updateBuyList(buyer, buyerlist);
        }
    }

    public String getType() {
        return _C__96_SENDPRIVATESTOREBUYBUYLIST;
    }
}

