/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.handler.IVoicedCommandHandler;
import net.sf.l2j.gameserver.handler.VoicedCommandHandler;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.CreatureSay;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class Say2
extends ClientBasePacket {
    private static final String _C__38_SAY2 = "[C] 38 Say2";
    private static Logger _log = Logger.getLogger(Say2.class.getName());
    private static Logger _logChat = Logger.getLogger("chat");
    public static final int ALL = 0;
    public static final int SHOUT = 1;
    public static final int TELL = 2;
    public static final int PARTY = 3;
    public static final int CLAN = 4;
    public static final int GM = 5;
    public static final int PETITION_PLAYER = 6;
    public static final int PETITION_GM = 7;
    public static final int TRADE = 8;
    public static final int ALLIANCE = 9;
    public static final int ANNOUNCEMENT = 10;
    public static final String[] chatNames = new String[]{"ALL  ", "SHOUT", "TELL ", "PARTY", "CLAN ", "GM   ", "PETITION_PLAYER", "PETITION_GM", "TRADE", "ALLIANCE", "ANNOUNCEMENT"};
    private static String gobalChatState = Config.DEFAULT_GLOBAL_CHAT;
    private final String _text = this.readS();
    private final int _type = this.readD();
    private final String _target = this._type == 2 ? this.readS() : null;

    public Say2(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        block21: {
            CreatureSay cs;
            L2PcInstance activeChar;
            block23: {
                block22: {
                    block20: {
                        if (Config.DEBUG) {
                            _log.fine("Say type:" + this._type);
                        }
                        activeChar = this.getClient().getActiveChar();
                        if (Config.LOG_CHAT) {
                            LogRecord record = new LogRecord(Level.INFO, this._text);
                            record.setLoggerName("chat");
                            if (this._type == 2) {
                                record.setParameters(new Object[]{chatNames[this._type], "[" + activeChar.getName() + " to " + this._target + "]"});
                            } else {
                                record.setParameters(new Object[]{chatNames[this._type], "[" + activeChar.getName() + "]"});
                            }
                            _logChat.log(record);
                        }
                        cs = new CreatureSay(activeChar.getObjectId(), this._type, activeChar.getName(), this._text);
                        if (this._type != 2) break block20;
                        L2PcInstance receiver = L2World.getInstance().getPlayer(this._target);
                        if (receiver != null) {
                            receiver.sendPacket(cs);
                            cs = new CreatureSay(activeChar.getObjectId(), this._type, receiver.getName(), "->" + this._text);
                            activeChar.sendPacket(cs);
                        } else {
                            SystemMessage sm = new SystemMessage(3);
                            sm.addString(this._target);
                            activeChar.sendPacket(sm);
                        }
                        break block21;
                    }
                    if (this._type != 1 && this._type != 8) break block22;
                    if (gobalChatState.equalsIgnoreCase("on") || gobalChatState.equalsIgnoreCase("gm") && activeChar.isGM()) {
                        for (L2PcInstance player : L2World.getInstance().getAllPlayers()) {
                            player.sendPacket(cs);
                        }
                    } else {
                        for (L2PcInstance player : L2World.getInstance().getAllPlayers()) {
                            if (!(activeChar.getDistance(player.getX(), player.getY()) < 10000.0)) continue;
                            player.sendPacket(cs);
                        }
                    }
                    break block21;
                }
                if (this._type != 0) break block23;
                for (L2PcInstance player : activeChar.getKnownPlayers()) {
                    if (!(activeChar.getDistance(player.getX(), player.getY()) < 1250.0)) continue;
                    player.sendPacket(cs);
                }
                activeChar.sendPacket(cs);
                if (!this._text.startsWith(".")) break block21;
                StringTokenizer st = new StringTokenizer(this._text);
                String target = st.nextToken().substring(1);
                if (st.hasMoreTokens()) {
                    String command = st.nextToken();
                    IVoicedCommandHandler vch = VoicedCommandHandler.getInstance().getVoicedCommandHandler(command);
                    if (vch != null) {
                        vch.useVoicedCommand(command, activeChar, target);
                    } else {
                        _log.warning("No handler registered for bypass '" + command + "'");
                    }
                }
                break block21;
            }
            if (this._type == 4 && activeChar.getClan() != null) {
                activeChar.getClan().broadcastToOnlineMembers(cs);
            } else if (this._type == 3 && activeChar.isInParty()) {
                activeChar.getParty().broadcastToPartyMembers(cs);
            } else if (this._type == 6) {
                for (L2PcInstance gm : L2World.getInstance().getAllGMs()) {
                    gm.sendPacket(cs);
                }
            }
        }
    }

    public String getType() {
        return _C__38_SAY2;
    }
}

