/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestUnEquipItem
extends ClientBasePacket {
    private static final String _C__11_REQUESTUNEQUIPITEM = "[C] 11 RequestUnequipItem";
    private static Logger _log = Logger.getLogger(RequestUnEquipItem.class.getName());
    private final int _slot = this.readD();

    public RequestUnEquipItem(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        if (Config.DEBUG) {
            _log.fine("request unequip slot " + this._slot);
        }
        L2PcInstance activeChar = this.getClient().getActiveChar();
        L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInBodySlotAndRecord(this._slot);
        InventoryUpdate iu = new InventoryUpdate();
        for (int i = 0; i < unequiped.length; ++i) {
            iu.addModifiedItem(unequiped[i]);
        }
        activeChar.sendPacket(iu);
        activeChar.abortAttack();
        activeChar.broadcastUserInfo();
        if (unequiped.length > 0) {
            SystemMessage sm = new SystemMessage(417);
            sm.addItemName(unequiped[0].getItemId());
            activeChar.sendPacket(sm);
        }
    }

    public String getType() {
        return _C__11_REQUESTUNEQUIPITEM;
    }
}

