/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2ShortCut;
import net.sf.l2j.gameserver.serverpackets.ShortCutRegister;

public class RequestShortCutReg
extends ClientBasePacket {
    private static final String _C__33_REQUESTSHORTCUTREG = "[C] 33 RequestShortCutReg";
    private final int _type = this.readD();
    private final int _id;
    private final int _slot;
    private final int _page;
    private final int _unk;

    public RequestShortCutReg(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        int slot = this.readD();
        this._id = this.readD();
        this._unk = this.readD();
        if (this.getClient().getRevision() >= 514) {
            this._slot = slot % 12;
            this._page = slot / 12;
        } else {
            this._slot = slot % 10;
            this._page = slot / 10;
        }
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        switch (this._type) {
            case 1: 
            case 3: 
            case 4: {
                L2ShortCut sc = new L2ShortCut(this._slot, this._page, this._type, this._id, -1, this._unk);
                this.sendPacket(new ShortCutRegister(sc));
                activeChar.registerShortCut(sc);
                break;
            }
            case 2: {
                int level = activeChar.getSkillLevel(this._id);
                if (level <= 0) break;
                L2ShortCut sc = new L2ShortCut(this._slot, this._page, this._type, this._id, level, this._unk);
                this.sendPacket(new ShortCutRegister(sc));
                activeChar.registerShortCut(sc);
                break;
            }
        }
    }

    public String getType() {
        return _C__33_REQUESTSHORTCUTREG;
    }
}

