/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ManufactureItem;
import net.sf.l2j.gameserver.model.L2ManufactureList;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.RecipeShopMsg;

public class RequestRecipeShopListSet
extends ClientBasePacket {
    private static final String _C__B2_RequestRecipeShopListSet = "[C] b2 RequestRecipeShopListSet";
    private static Logger _log = Logger.getLogger(RequestRecipeShopListSet.class.getName());
    private final int _count = this.readD();
    private final int[] _items = new int[this._count * 2];

    public RequestRecipeShopListSet(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        for (int x = 0; x < this._count; ++x) {
            int cost;
            int recipeID;
            this._items[x * 2 + 0] = recipeID = this.readD();
            this._items[x * 2 + 1] = cost = this.readD();
        }
    }

    void runImpl() {
        L2PcInstance player = this.getClient().getActiveChar();
        if (this._count == 0) {
            player.setPrivateStoreType(0);
            player.broadcastUserInfo();
            player.standUp();
        } else {
            L2ManufactureList createList = new L2ManufactureList();
            for (int x = 0; x < this._count; ++x) {
                int recipeID = this._items[x * 2 + 0];
                int cost = this._items[x * 2 + 1];
                createList.add(new L2ManufactureItem(recipeID, cost));
            }
            createList.setStoreName(player.getCreateList().getStoreName());
            player.setCreateList(createList);
            player.setPrivateStoreType(5);
            player.sitDown();
            player.broadcastUserInfo();
            player.sendPacket(new RecipeShopMsg(player));
            player.broadcastPacket(new RecipeShopMsg(player));
        }
    }

    public String getType() {
        return _C__B2_RequestRecipeShopListSet;
    }
}

