/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2TradeList;
import net.sf.l2j.gameserver.model.TradeItem;
import net.sf.l2j.gameserver.serverpackets.ChangeWaitType;
import net.sf.l2j.gameserver.serverpackets.PrivateSellListBuy;

public class RequestPrivateStoreBuyManage
extends ClientBasePacket {
    private static final String _C__90_REQUESTPRIVATESTOREBUYMANAGE = "[C] 90 RequestPrivateStoreBuyManage";
    private static Logger _log = Logger.getLogger(RequestPrivateStoreBuyManage.class.getName());

    public RequestPrivateStoreBuyManage(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance player = this.getClient().getActiveChar();
        switch (player.getPrivateStoreType()) {
            case 0: {
                if (player.isSitting()) {
                    player.isInStoreMode(false);
                    player.standUp();
                }
                if (player.getTradeList() == null) {
                    player.setTradeList(new L2TradeList(0));
                }
                if (player.getBuyList() == null) {
                    player.setBuyList(new ArrayList<TradeItem>());
                }
                player.getTradeList().updateBuyList(player, player.getBuyList());
                player.setPrivateStoreType(4);
                player.sendPacket(new PrivateSellListBuy(this.getClient().getActiveChar()));
                break;
            }
            case 3: {
                player.setPrivateStoreType(4);
                player.isInStoreMode(true);
                player.sendPacket(new PrivateSellListBuy(this.getClient().getActiveChar()));
                player.sendPacket(new ChangeWaitType(player, true));
                player.broadcastPacket(new ChangeWaitType(player, true));
                player.sitDown();
            }
        }
    }

    public String getType() {
        return _C__90_REQUESTPRIVATESTOREBUYMANAGE;
    }
}

