/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClanTable;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.PledgeInfo;
import net.sf.l2j.gameserver.serverpackets.PledgeShowMemberListAll;

public class RequestPledgeInfo
extends ClientBasePacket {
    private static final String _C__66_REQUESTPLEDGEINFO = "[C] 66 RequestPledgeInfo";
    private static Logger _log = Logger.getLogger(RequestPledgeInfo.class.getName());
    private final int _clanId = this.readD();

    public RequestPledgeInfo(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        if (Config.DEBUG) {
            _log.fine("infos for clan " + this._clanId + " requested");
        }
        L2PcInstance activeChar = this.getClient().getActiveChar();
        L2Clan clan = ClanTable.getInstance().getClan(this._clanId);
        if (clan == null) {
            _log.warning("Clan data for clanId " + this._clanId + " is missing");
            return;
        }
        PledgeInfo pc = new PledgeInfo(clan);
        activeChar.sendPacket(pc);
        if (clan.getClanId() == activeChar.getClanId()) {
            PledgeShowMemberListAll pm = new PledgeShowMemberListAll(clan, activeChar);
            activeChar.sendPacket(pm);
        }
    }

    public String getType() {
        return _C__66_REQUESTPLEDGEINFO;
    }
}

