/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.handler.IItemHandler;
import net.sf.l2j.gameserver.handler.ItemHandler;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PetInstance;
import net.sf.l2j.gameserver.serverpackets.PetInfo;
import net.sf.l2j.gameserver.serverpackets.PetItemList;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestPetUseItem
extends ClientBasePacket {
    private static Logger _log = Logger.getLogger(RequestPetUseItem.class.getName());
    private static final String _C__8A_REQUESTPETUSEITEM = "[C] 8a RequestPetUseItem";
    private final int _objectId = this.readD();

    public RequestPetUseItem(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        L2PetInstance pet = (L2PetInstance)activeChar.getPet();
        L2ItemInstance item = pet.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        int itemId = item.getItemId();
        if (activeChar.isAlikeDead() || pet.isDead()) {
            SystemMessage sm = new SystemMessage(113);
            sm.addItemName(item.getItemId());
            activeChar.sendPacket(sm);
            return;
        }
        if (Config.DEBUG) {
            _log.finest(activeChar.getObjectId() + ": pet use item " + this._objectId);
        }
        if (item.isEquipable()) {
            if (pet.getNpcId() == 12077 && (itemId == 2505 || itemId == 3439 || itemId >= 3902 && itemId <= 3911 || itemId == 2506 || itemId >= 3891 && itemId <= 3901)) {
                this.useItem(pet, item, activeChar);
                return;
            }
            if ((pet.getNpcId() >= 12311 && pet.getNpcId() <= 12313 || pet.getNpcId() >= 12526 && pet.getNpcId() <= 12528) && (itemId >= 3919 && itemId <= 3925 || itemId >= 3912 && itemId <= 3918)) {
                this.useItem(pet, item, activeChar);
                return;
            }
            SystemMessage sm = new SystemMessage(544);
            activeChar.sendPacket(sm);
        } else if (itemId == 2515 || itemId == 4038 || itemId == 5168) {
            if (pet.getNpcId() == 12077 && itemId == 2515) {
                this.Feed(pet, item, activeChar);
                return;
            }
            if (pet.getNpcId() >= 12311 && pet.getNpcId() <= 12313 && itemId == 4038) {
                this.Feed(pet, item, activeChar);
                return;
            }
            if (pet.getNpcId() >= 12526 && pet.getNpcId() <= 12528 && itemId == 5168) {
                this.Feed(pet, item, activeChar);
                return;
            }
        }
        IItemHandler handler = ItemHandler.getInstance().getItemHandler(item.getItemId());
        if (handler != null) {
            this.useItem(pet, item, activeChar);
        } else {
            SystemMessage sm = new SystemMessage(544);
            activeChar.sendPacket(sm);
        }
    }

    private synchronized void useItem(L2PetInstance pet, L2ItemInstance item, L2PcInstance activeChar) {
        if (item.isEquipable()) {
            if (item.isEquipped()) {
                pet.getInventory().unEquipItemInSlot(item.getEquipSlot());
            } else {
                pet.getInventory().equipItem(item);
            }
            PetItemList pil = new PetItemList(pet);
            activeChar.sendPacket(pil);
            PetInfo pi = new PetInfo(pet);
            activeChar.sendPacket(pi);
        } else {
            IItemHandler handler = ItemHandler.getInstance().getItemHandler(item.getItemId());
            if (handler == null) {
                _log.warning("no itemhandler registered for itemId:" + item.getItemId());
            } else {
                handler.useItem(pet, item);
            }
        }
    }

    private void Feed(L2PetInstance pet, L2ItemInstance item, L2PcInstance activeChar) {
        if (pet.getCurrentFed() <= item.getCount()) {
            pet.setCurrentFed(pet.getCurrentFed() + item.getCount());
            pet.removeItemFromInventory(item, item.getCount());
        } else {
            pet.removeItemFromInventory(item, pet.getMaxFed() - pet.getCurrentFed());
            pet.setCurrentFed(pet.getMaxFed());
        }
        pet.broadcastStatusUpdate();
    }

    public String getType() {
        return _C__8A_REQUESTPETUSEITEM;
    }
}

