/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.AskJoinPledge;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestJoinPledge
extends ClientBasePacket {
    private static final String _C__24_REQUESTJOINPLEDGE = "[C] 24 RequestJoinPledge";
    static Logger _log = Logger.getLogger(RequestJoinPledge.class.getName());
    private final int _target = this.readD();

    public RequestJoinPledge(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2Object object;
        L2PcInstance activeChar = this.getClient().getActiveChar();
        if (activeChar.isTransactionInProgress()) {
            activeChar.sendPacket(new SystemMessage(164));
            if (Config.DEBUG) {
                _log.fine("player is already doing some other action");
            }
            return;
        }
        if (this._target == activeChar.getObjectId()) {
            SystemMessage sm = new SystemMessage(4);
            activeChar.sendPacket(sm);
            return;
        }
        if (activeChar.isClanLeader() && (object = L2World.getInstance().findObject(this._target)) instanceof L2PcInstance) {
            L2PcInstance member = (L2PcInstance)object;
            L2Clan clan = activeChar.getClan();
            int limit = 0;
            switch (clan.getLevel()) {
                case 3: {
                    limit = 30;
                    break;
                }
                case 2: {
                    limit = 20;
                    break;
                }
                case 1: {
                    limit = 15;
                    break;
                }
                case 0: {
                    limit = 10;
                    break;
                }
                default: {
                    limit = 40;
                }
            }
            if (member.getClanId() != 0) {
                SystemMessage sm = new SystemMessage(10);
                sm.addString(member.getName());
                activeChar.sendPacket(sm);
                return;
            }
            if (member.isTransactionInProgress()) {
                SystemMessage sm = new SystemMessage(153);
                sm.addString(member.getName());
                activeChar.sendPacket(sm);
                return;
            }
            if (clan.getMembers().length >= limit) {
                SystemMessage sm = new SystemMessage(614);
                sm.addString("The clan is full, you cannot invite any more players.");
                activeChar.sendPacket(sm);
                return;
            }
            member.setTransactionRequester(activeChar);
            activeChar.setTransactionRequester(member);
            AskJoinPledge ap = new AskJoinPledge(activeChar.getObjectId(), activeChar.getClan().getName());
            member.sendPacket(ap);
        }
    }

    public String getType() {
        return _C__24_REQUESTJOINPLEDGE;
    }
}

