/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2PetInstance;
import net.sf.l2j.gameserver.model.PcInventory;
import net.sf.l2j.gameserver.model.PetInventory;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.PetItemList;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestGiveItemToPet
extends ClientBasePacket {
    private static final String REQUESTCIVEITEMTOPET__C__8B = "[C] 8B RequestGiveItemToPet";
    private static Logger _log = Logger.getLogger(RequestGiveItemToPet.class.getName());
    private final int _objectId = this.readD();
    private final int _amount = this.readD();

    public RequestGiveItemToPet(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance player = this.getClient().getActiveChar();
        L2PetInstance pet = (L2PetInstance)player.getPet();
        if (pet == null || pet.isDead()) {
            SystemMessage sm = new SystemMessage(590);
            this.sendPacket(sm);
            return;
        }
        PetInventory petInventory = pet.getInventory();
        PcInventory playerInventory = player.getInventory();
        L2ItemInstance playerItem = playerInventory.getItemByObjectId(this._objectId);
        if (playerItem.getObjectId() == pet.getControlItemId()) {
            return;
        }
        if (this._amount >= playerItem.getCount()) {
            playerInventory.dropItem(this._objectId, playerItem.getCount());
            petInventory.addItem(playerItem);
            InventoryUpdate playerUI = new InventoryUpdate();
            playerUI.addRemovedItem(playerItem);
            this.sendPacket(playerUI);
            PetItemList petiu = new PetItemList(pet);
            this.sendPacket(petiu);
        } else {
            L2ItemInstance newPetItem = playerInventory.dropItem(this._objectId, this._amount);
            petInventory.addItem(newPetItem);
            PetItemList petiu = new PetItemList(pet);
            InventoryUpdate playerUI = new InventoryUpdate();
            playerUI.addModifiedItem(playerItem);
            this.sendPacket(petiu);
            this.sendPacket(playerUI);
        }
    }

    public String getType() {
        return REQUESTCIVEITEMTOPET__C__8B;
    }
}

