/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.ItemList;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.serverpackets.UserInfo;

public class RequestDropItem
extends ClientBasePacket {
    private static final String _C__12_REQUESTDROPITEM = "[C] 12 RequestDropItem";
    private static Logger _log = Logger.getLogger(RequestDropItem.class.getName());
    private final int _objectId = this.readD();
    private final int _count = this.readD();
    private final int _x = this.readD();
    private final int _y = this.readD();
    private final int _z = this.readD();

    public RequestDropItem(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        if (this._count == 0) {
            return;
        }
        L2PcInstance activeChar = this.getClient().getActiveChar();
        if (activeChar.getPrivateStoreType() != 0) {
            activeChar.sendPacket(new SystemMessage(1065));
            return;
        }
        if (!activeChar.isTransactionInProgress()) {
            ItemList il;
            InventoryUpdate iu;
            L2ItemInstance oldItem = activeChar.getInventory().getItemByObjectId(this._objectId);
            if (oldItem == null) {
                _log.warning("tried to drop an item that is not in the inventory ?!?:" + this._objectId);
                return;
            }
            int oldCount = oldItem.getCount();
            if (Config.DEBUG) {
                _log.fine("requested drop item " + this._objectId + "(" + oldCount + ") at " + this._x + "/" + this._y + "/" + this._z);
            }
            if (3 == oldItem.getItem().getType2()) {
                if (Config.DEBUG) {
                    _log.finest(activeChar.getObjectId() + ":player tried to drop quest item");
                }
                return;
            }
            if (oldCount < this._count) {
                if (Config.DEBUG) {
                    _log.finest(activeChar.getObjectId() + ":player tried to drop more items than he has");
                }
                return;
            }
            if (activeChar.getDistance(this._x, this._y) > 150.0 || Math.abs(this._z - activeChar.getZ()) > 50) {
                if (Config.DEBUG) {
                    _log.finest(activeChar.getObjectId() + ": trying to drop too far away");
                }
                SystemMessage sm = new SystemMessage(151);
                activeChar.sendPacket(sm);
                return;
            }
            if (oldItem.isEquipped()) {
                L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInBodySlotAndRecord(oldItem.getItem().getBodyPart());
                iu = new InventoryUpdate();
                for (int i = 0; i < unequiped.length; ++i) {
                    iu.addModifiedItem(unequiped[i]);
                }
                activeChar.sendPacket(iu);
                activeChar.broadcastUserInfo();
                il = new ItemList(activeChar, true);
                activeChar.sendPacket(il);
            }
            L2ItemInstance dropedItem = activeChar.getInventory().dropItem(this._objectId, this._count);
            if (Config.DEBUG) {
                _log.fine("dropping " + this._objectId + " item(" + this._count + ") at: " + this._x + " " + this._y + " " + this._z);
            }
            dropedItem.dropMe(activeChar, this._x, this._y, this._z);
            iu = new InventoryUpdate();
            if (oldCount == dropedItem.getCount()) {
                if (Config.DEBUG) {
                    _log.finest("remove item from inv");
                }
                iu.addRemovedItem(oldItem);
            } else {
                if (Config.DEBUG) {
                    _log.finest("reducing item in inv");
                }
                iu.addModifiedItem(oldItem);
            }
            activeChar.sendPacket(iu);
            il = new ItemList(activeChar, true);
            activeChar.sendPacket(il);
            StatusUpdate su = new StatusUpdate(activeChar.getObjectId());
            su.addAttribute(StatusUpdate.CUR_LOAD, activeChar.getCurrentLoad());
            activeChar.sendPacket(su);
            SystemMessage sm = new SystemMessage(298);
            sm.addItemName(dropedItem.getItemId());
            activeChar.sendPacket(sm);
            activeChar.broadcastUserInfo();
            activeChar.sendPacket(new UserInfo(activeChar));
            if (dropedItem.getItemId() == 57 && dropedItem.getCount() >= 1000000) {
                String msg = "Character (" + activeChar.getName() + ") has dropped (" + dropedItem.getCount() + ")adena at (" + this._x + "," + this._y + "," + this._z + ")";
                _log.warning(msg);
                L2PcInstance[] list = L2World.getInstance().getAllGMs();
                sm = new SystemMessage(614);
                sm.addString(msg);
                for (int i = 0; i < list.length; ++i) {
                    list[i].sendPacket(sm);
                }
            }
        } else {
            SystemMessage msg = new SystemMessage(61);
            this.sendPacket(msg);
        }
    }

    public String getType() {
        return _C__12_REQUESTDROPITEM;
    }
}

