/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.InventoryUpdate;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestCrystallizeItem
extends ClientBasePacket {
    private static final String _C__72_REQUESTDCRYSTALLIZEITEM = "[C] 72 RequestCrystallizeItem";
    private static Logger _log = Logger.getLogger(RequestCrystallizeItem.class.getName());
    private static final int[] _crystalId = new int[]{0, 1458, 1459, 1460, 1461, 1462};
    private final int _objectId = this.readD();
    private int _count = this.readD();

    public RequestCrystallizeItem(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2ItemInstance itemToRemove;
        L2PcInstance activeChar = this.getClient().getActiveChar();
        int skillLevel = activeChar.getSkillLevel(248);
        if (skillLevel <= 0) {
            SystemMessage sm = new SystemMessage(562);
            activeChar.sendPacket(sm);
            ActionFailed af = new ActionFailed();
            activeChar.sendPacket(af);
            return;
        }
        if (this._count > activeChar.getInventory().getItemByObjectId(this._objectId).getCount()) {
            this._count = activeChar.getInventory().getItemByObjectId(this._objectId).getCount();
        }
        if (!(itemToRemove = activeChar.getInventory().getItemByObjectId(this._objectId)).getItem().isCrystallizable() || itemToRemove.getItem().getCrystalCount() <= 0 || itemToRemove.getItem().getCrystalType() == 0) {
            _log.warning("" + activeChar.getObjectId() + " tried to crystallize " + itemToRemove.getItem().getItemId());
            return;
        }
        if (itemToRemove.getItem().getCrystalType() == 2 && skillLevel <= 1) {
            SystemMessage sm = new SystemMessage(562);
            activeChar.sendPacket(sm);
            ActionFailed af = new ActionFailed();
            activeChar.sendPacket(af);
            return;
        }
        if (itemToRemove.getItem().getCrystalType() == 3 && skillLevel <= 2) {
            SystemMessage sm = new SystemMessage(562);
            activeChar.sendPacket(sm);
            ActionFailed af = new ActionFailed();
            activeChar.sendPacket(af);
            return;
        }
        if (itemToRemove.getItem().getCrystalType() == 4 && skillLevel <= 3) {
            SystemMessage sm = new SystemMessage(562);
            activeChar.sendPacket(sm);
            ActionFailed af = new ActionFailed();
            activeChar.sendPacket(af);
            return;
        }
        if (itemToRemove.getItem().getCrystalType() == 5 && skillLevel <= 4) {
            SystemMessage sm = new SystemMessage(562);
            activeChar.sendPacket(sm);
            ActionFailed af = new ActionFailed();
            activeChar.sendPacket(af);
            return;
        }
        if (itemToRemove.isEquipped()) {
            L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInSlotAndRecord(itemToRemove.getEquipSlot());
            InventoryUpdate iu = new InventoryUpdate();
            for (int i = 0; i < unequiped.length; ++i) {
                iu.addModifiedItem(unequiped[i]);
            }
            activeChar.sendPacket(iu);
        }
        L2ItemInstance removedItem = activeChar.getInventory().destroyItem(this._objectId, this._count);
        int crystalAmount = itemToRemove.getItem().getCrystalCount();
        int crystalId = _crystalId[itemToRemove.getItem().getCrystalType()];
        L2ItemInstance createditem = ItemTable.getInstance().createItem(crystalId);
        createditem.setCount(crystalAmount);
        L2ItemInstance addedItem = activeChar.getInventory().addItem(createditem);
        InventoryUpdate iu = new InventoryUpdate();
        if (removedItem.getCount() == 0) {
            iu.addRemovedItem(removedItem);
        } else {
            iu.addModifiedItem(removedItem);
        }
        if (addedItem.getCount() != crystalAmount) {
            iu.addModifiedItem(addedItem);
        } else {
            iu.addNewItem(addedItem);
        }
        activeChar.sendPacket(iu);
        StatusUpdate su = new StatusUpdate(activeChar.getObjectId());
        su.addAttribute(StatusUpdate.CUR_LOAD, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
        activeChar.broadcastUserInfo();
        L2World world = L2World.getInstance();
        world.removeObject(removedItem);
    }

    public String getType() {
        return _C__72_REQUESTDCRYSTALLIZEITEM;
    }
}

