/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.ExAutoSoulShot;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.L2Item;

public class RequestAutoSoulShot
extends ClientBasePacket {
    private static final String _C__CF_REQUESTAUTOSOULSHOT = "[C] CF RequestAutoSoulShot";
    private static Logger _log = Logger.getLogger(RequestAutoSoulShot.class.getName());
    private final int _itemId = this.readD();
    private final int _type = this.readD();

    public RequestAutoSoulShot(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        if (activeChar.getPrivateStoreType() == 0 && activeChar.getTransactionRequester() == null && !activeChar.isDead()) {
            if (Config.DEBUG) {
                _log.fine("AutoSoulShot:" + this._itemId);
            }
            L2ItemInstance item = activeChar.getInventory().findItemByItemId(this._itemId);
            L2Item tempItem = ItemTable.getInstance().getTemplate(item.getItemId());
            String tempName = tempItem.getName();
            if (this._type == 1) {
                if (item == null) {
                    _log.warning("Bad item id (" + this._itemId + ") was given to RequestAutoSoulShot.");
                    activeChar.sendPacket(new ActionFailed());
                    return;
                }
                activeChar.addAutoSoulShot(this._itemId);
                ExAutoSoulShot atk = new ExAutoSoulShot(this._itemId, this._type);
                activeChar.sendPacket(atk);
                SystemMessage sm = new SystemMessage(614);
                sm.addString("The use of " + tempName + " will now be automated.");
                activeChar.sendPacket(sm);
            } else if (this._type == 0) {
                activeChar.removeAutoSoulShot(this._itemId);
                ExAutoSoulShot atk = new ExAutoSoulShot(this._itemId, this._type);
                activeChar.sendPacket(atk);
                SystemMessage sm = new SystemMessage(614);
                sm.addString("The automatic use of " + tempName + " will now be cancelled.");
                activeChar.sendPacket(sm);
            }
        }
    }

    public String getType() {
        return _C__CF_REQUESTAUTOSOULSHOT;
    }
}

