/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.SkillSpellbookTable;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.SkillTreeTable;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.AquireSkillInfo;

public class RequestAquireSkillInfo
extends ClientBasePacket {
    private static final String _C__6B_REQUESTAQUIRESKILLINFO = "[C] 6B RequestAquireSkillInfo";
    private static Logger _log = Logger.getLogger(RequestAquireSkillInfo.class.getName());
    private final int _id = this.readD();
    private final int _level = this.readD();

    public RequestAquireSkillInfo(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar = this.getClient().getActiveChar();
        L2FolkInstance trainer = activeChar.getLastFolkNPC();
        if ((trainer == null || activeChar.getDistance(trainer.getX(), trainer.getY()) > 150.0) && !activeChar.isGM()) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._id, this._level);
        if (skill == null) {
            _log.warning("skill id " + this._id + " level " + this._level + " is undefined. aquireSkillInfo failed.");
            return;
        }
        int requiredSp = SkillTreeTable.getInstance().getSkillCost(activeChar, skill);
        AquireSkillInfo asi = new AquireSkillInfo(skill.getId(), skill.getLevel(), requiredSp);
        if (Config.SP_BOOK_NEEDED) {
            Integer spb_id = SkillSpellbookTable._skillSpellbooks.get(skill.getId());
            if (skill.getLevel() == 1 && spb_id != null) {
                asi.addRequirement(99, spb_id, 1, 50);
            }
        }
        this.sendPacket(asi);
    }

    public String getType() {
        return _C__6B_REQUESTAQUIRESKILLINFO;
    }
}

