/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.SkillSpellbookTable;
import net.sf.l2j.gameserver.SkillTable;
import net.sf.l2j.gameserver.SkillTreeTable;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2FolkInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2ShortCut;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.serverpackets.ShortCutRegister;
import net.sf.l2j.gameserver.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestAquireSkill
extends ClientBasePacket {
    private static final String _C__6C_REQUESTAQUIRESKILL = "[C] 6C RequestAquireSkill";
    private static Logger _log = Logger.getLogger(RequestAquireSkill.class.getName());
    private final int _id = this.readD();
    private final int _level = this.readD();

    public RequestAquireSkill(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance player = this.getClient().getActiveChar();
        L2FolkInstance trainer = player.getLastFolkNPC();
        if ((trainer == null || player.getDistance(trainer.getX(), trainer.getY()) > 150.0) && !player.isGM()) {
            return;
        }
        if (player.getSkillLevel(this._id) >= this._level) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._id, this._level);
        int _requiredSp = SkillTreeTable.getInstance().getSkillCost(player, skill);
        if (player.getSp() >= _requiredSp) {
            if (Config.SP_BOOK_NEEDED) {
                Integer spb_id = SkillSpellbookTable._skillSpellbooks.get(skill.getId());
                if (skill.getLevel() == 1 && spb_id != null) {
                    L2ItemInstance spb = player.getInventory().findItemByItemId(spb_id);
                    if (spb == null) {
                        player.sendPacket(new SystemMessage(276));
                        return;
                    }
                    player.getInventory().destroyItemByItemId(spb_id, 1);
                }
            }
            player.addSkill(skill);
            if (Config.DEBUG) {
                _log.fine("Learned skill " + this._id + " for " + _requiredSp + " SP.");
            }
            player.setSp(player.getSp() - _requiredSp);
            player.updateStats();
            StatusUpdate su = new StatusUpdate(player.getObjectId());
            su.addAttribute(StatusUpdate.SP, player.getSp());
            player.sendPacket(su);
            SystemMessage sm = new SystemMessage(277);
            sm.addSkillName(this._id);
            player.sendPacket(sm);
            if (this._level > 1) {
                L2ShortCut[] allShortCuts;
                for (L2ShortCut sc : allShortCuts = player.getAllShortCuts()) {
                    if (sc.id != this._id || sc.type != 2) continue;
                    L2ShortCut newsc = new L2ShortCut(sc.slot, sc.page, sc.type, sc.id, this._level, sc.unk);
                    player.sendPacket(new ShortCutRegister(newsc));
                    player.registerShortCut(newsc);
                }
            }
        } else {
            SystemMessage sm = new SystemMessage(278);
            player.sendPacket(sm);
            if (Config.DEBUG) {
                _log.fine("Not enough SP!");
            }
        }
        trainer.showSkillList(player, player.getSkillLearningClassId());
    }

    public String getType() {
        return _C__6C_REQUESTAQUIRESKILL;
    }
}

