/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.model.L2DoorInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2PcInstance;
import net.sf.l2j.gameserver.model.L2Summon;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.serverpackets.Ride;
import net.sf.l2j.gameserver.serverpackets.SystemMessage;

public class RequestActionUse
extends ClientBasePacket {
    private static final String _C__45_REQUESTACTIONUSE = "[C] 45 RequestActionUse";
    private static Logger _log = Logger.getLogger(RequestActionUse.class.getName());
    private final int _actionId = this.readD();
    private final boolean _ctrlPressed = this.readD() == 1;
    private final boolean _shiftPressed = this.readC() == 1;

    public RequestActionUse(ByteBuffer buf, ClientThread client) {
        super(buf, client);
    }

    void runImpl() {
        L2PcInstance activeChar;
        if (Config.DEBUG) {
            _log.finest("request Action use: id " + this._actionId + " 2:" + this._ctrlPressed + " 3:" + this._shiftPressed);
        }
        if ((activeChar = this.getClient().getActiveChar()).isDead()) {
            activeChar.sendPacket(new ActionFailed());
            return;
        }
        if (activeChar.isOutOfControl()) {
            activeChar.sendPacket(new ActionFailed());
            return;
        }
        switch (this._actionId) {
            case 0: {
                if (activeChar.isSitting()) {
                    activeChar.standUp();
                } else {
                    activeChar.sitDown();
                }
                if (!Config.DEBUG) break;
                _log.fine("new wait type: " + (activeChar.isSitting() ? "STANDING" : "SITTING"));
                break;
            }
            case 1: {
                if (activeChar.isRunning()) {
                    activeChar.setWalking();
                } else {
                    activeChar.setRunning();
                }
                if (!Config.DEBUG) break;
                _log.fine("new move type: " + (activeChar.isRunning() ? "RUNNING" : "WALKIN"));
                break;
            }
            case 15: 
            case 21: {
                L2Summon pet = activeChar.getPet();
                if (pet == null) break;
                pet.setFollowStatus(!pet.getFollowStatus());
                break;
            }
            case 16: 
            case 22: {
                L2Object target = activeChar.getTarget();
                if (target == null || activeChar.getPet() == null || activeChar.getPet() == target || activeChar == target) break;
                if (activeChar.getPet().withinZones(L2World.zones) || target.withinZones(L2World.zones)) {
                    activeChar.sendPacket(new SystemMessage(85));
                    return;
                }
                if (!target.isAutoAttackable(activeChar) && !this._ctrlPressed || activeChar.getPet().getNpcId() == 12251 && !(activeChar.getTarget() instanceof L2DoorInstance)) break;
                activeChar.getPet().getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, activeChar.getTarget());
                break;
            }
            case 17: 
            case 23: {
                L2Summon pet = activeChar.getPet();
                if (pet == null) break;
                pet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
                break;
            }
            case 18: {
                _log.warning("unhandled action type 18");
                break;
            }
            case 19: {
                if (activeChar.getPet() == null) break;
                if (activeChar.getPet().isDead()) {
                    SystemMessage sm = new SystemMessage(589);
                    activeChar.sendPacket(sm);
                    break;
                }
                activeChar.getPet().unSummon(activeChar);
                break;
            }
            case 20: {
                _log.warning("unhandled action type 20");
                break;
            }
            case 38: {
                L2Summon pet = activeChar.getPet();
                if (pet != null && pet.isMountable() && !activeChar.isMounted()) {
                    Ride mount = new Ride(activeChar.getObjectId(), 1, pet.getTemplate().npcId);
                    activeChar.sendPacket(mount);
                    activeChar.broadcastPacket(mount);
                    activeChar.setMountType(mount.getMountType());
                    pet.PetdeleteMe(activeChar);
                    break;
                }
                if (!activeChar.isMounted()) break;
                Ride dismount = new Ride(activeChar.getObjectId(), 0, 0);
                activeChar.sendPacket(dismount);
                activeChar.broadcastPacket(dismount);
                activeChar.setMountType(0);
                break;
            }
            default: {
                _log.warning("unhandled action type " + this._actionId);
            }
        }
    }

    public String getType() {
        return _C__45_REQUESTACTIONUSE;
    }
}

