/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.clientpackets;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ClientThread;
import net.sf.l2j.gameserver.TaskPriority;
import net.sf.l2j.gameserver.clientpackets.ClientBasePacket;
import net.sf.l2j.gameserver.serverpackets.KeyPacket;

public class ProtocolVersion
extends ClientBasePacket {
    private static final String _C__00_PROTOCOLVERSION = "[C] 00 ProtocolVersion";
    static Logger _log = Logger.getLogger(ProtocolVersion.class.getName());
    private final long _version = this.readD();

    public ProtocolVersion(ByteBuffer buf, ClientThread client) {
        super(buf, client);
        while (buf.hasRemaining()) {
            buf.get();
        }
    }

    public TaskPriority getPriority() {
        return TaskPriority.PR_URGENT;
    }

    void runImpl() {
        if (this._version == -2L) {
            if (Config.DEBUG) {
                _log.info("Ping received");
            }
            this.getConnection().close();
            return;
        }
        if (this._version < (long)Config.MIN_PROTOCOL_REVISION) {
            _log.info("Client Protocol Revision:" + this._version + " is too low. only " + Config.MIN_PROTOCOL_REVISION + " and " + Config.MAX_PROTOCOL_REVISION + " are supported. closing connection.");
            _log.warning("Wrong Protocol Version " + this._version);
            this.getConnection().close();
            return;
        }
        if (this._version > (long)Config.MAX_PROTOCOL_REVISION) {
            _log.info("Client Protocol Revision:" + this._version + " is too high. only " + Config.MIN_PROTOCOL_REVISION + " and " + Config.MAX_PROTOCOL_REVISION + " are supported. closing connection.");
            _log.warning("Wrong Protocol Version " + this._version);
            this.getConnection().close();
            return;
        }
        this.getClient().setRevision((int)this._version);
        if (Config.DEBUG) {
            _log.fine("Client Protocol Revision is ok:" + this._version);
        }
        KeyPacket pk = new KeyPacket();
        pk.setKey(this.getConnection().getCryptKey());
        this.sendPacket(pk);
        this.getConnection().activateCryptKey();
    }

    public String getType() {
        return _C__00_PROTOCOLVERSION;
    }
}

