/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver.ai;

import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.ai.L2CharacterAI;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Summon;

public class L2SummonAI
extends L2CharacterAI {
    private boolean thinking;

    public L2SummonAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    protected void onIntentionIdle() {
        this.onIntentionActive();
    }

    protected void onIntentionActive() {
        L2Summon summon = (L2Summon)this._actor;
        if (summon.getFollowStatus()) {
            this.setIntention(CtrlIntention.AI_INTENTION_FOLLOW, summon.getOwner());
        } else {
            super.onIntentionActive();
        }
    }

    private void thinkAttack() {
        if (this.checkTargetLostOrDead(this._attack_target)) {
            this._attack_target = null;
            return;
        }
        this.stopFollow();
        if (this.maybeMoveToPawn(this._attack_target, this._actor.getPhysicalAttackRange())) {
            return;
        }
        this.clientStopMoving(null);
        this.clientStartAutoAttack();
        this._accessor.doAttack(this._attack_target);
    }

    private void thinkCast() {
        if (this.checkTargetLost(this._cast_target)) {
            this._cast_target = null;
            return;
        }
        if (this.maybeMoveToPawn(this._cast_target, this._actor.getMagicalAttackRange(this._skill))) {
            return;
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
        this._accessor.doCast(this._skill);
    }

    private void thinkPickUp() {
        if (this._actor.isAllSkillsDisabled()) {
            return;
        }
        if (this.checkTargetLost(this._target)) {
            return;
        }
        if (this.maybeMoveToPawn(this._target, 36)) {
            return;
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
        ((L2Summon.AIAccessor)this._accessor).doPickupItem(this._target);
    }

    private void thinkInteract() {
        if (this._actor.isAllSkillsDisabled()) {
            return;
        }
        if (this.checkTargetLost(this._target)) {
            return;
        }
        if (this.maybeMoveToPawn(this._target, 36)) {
            return;
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvtThink() {
        if (this.thinking || this._actor.isAllSkillsDisabled()) {
            return;
        }
        this.thinking = true;
        try {
            if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                this.thinkAttack();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_CAST) {
                this.thinkCast();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_PICK_UP) {
                this.thinkPickUp();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_INTERACT) {
                this.thinkInteract();
            }
        }
        finally {
            this.thinking = false;
        }
    }
}

