/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.ItemTable;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2TradeList;

public class TradeController {
    private static Logger _log = Logger.getLogger(TradeController.class.getName());
    private static TradeController _instance;
    private int _nextListId;
    private HashMap<Integer, L2TradeList> _lists = new HashMap();

    public static TradeController getInstance() {
        if (_instance == null) {
            _instance = new TradeController();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TradeController() {
        File buylistData = new File(Config.DATAPACK_ROOT, "data/buylists.csv");
        if (buylistData.exists()) {
            _log.warning("Do, please, remove buylists from data folder and use SQL buylist instead");
            String line = null;
            LineNumberReader lnr = null;
            int dummyItemCount = 0;
            try {
                lnr = new LineNumberReader(new BufferedReader(new FileReader(buylistData)));
                while ((line = lnr.readLine()) != null) {
                    if (line.trim().length() == 0 || line.startsWith("#")) continue;
                    dummyItemCount += this.parseList(line);
                }
                if (Config.DEBUG) {
                    _log.fine("created " + dummyItemCount + " Dummy-Items for buylists");
                }
                _log.config("TradeController: Loaded " + this._lists.size() + " Buylists.");
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "error while creating trade controller in linenr: " + lnr.getLineNumber(), e);
            }
        } else {
            _log.finer("No buylists were found in data folder, using SQL buylist instead");
            Connection con = null;
            int dummyItemCount = 0;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement1 = con.prepareStatement("SELECT shop_id, npc_id FROM merchant_shopids");
                ResultSet rset1 = statement1.executeQuery();
                while (rset1.next()) {
                    PreparedStatement statement = con.prepareStatement("SELECT item_id, price, shop_id, `order` FROM merchant_buylists WHERE shop_id=? ORDER BY `order` ASC");
                    statement.setString(1, String.valueOf(rset1.getInt("shop_id")));
                    ResultSet rset = statement.executeQuery();
                    if (rset.next()) {
                        ++dummyItemCount;
                        L2TradeList buy1 = new L2TradeList(rset1.getInt("shop_id"));
                        int itemId = rset.getInt("item_id");
                        int price = rset.getInt("price");
                        L2ItemInstance item = ItemTable.getInstance().createDummyItem(itemId);
                        item.setPriceToSell(price);
                        buy1.addItem(item);
                        while (rset.next()) {
                            ++dummyItemCount;
                            itemId = rset.getInt("item_id");
                            price = rset.getInt("price");
                            L2ItemInstance item2 = ItemTable.getInstance().createDummyItem(itemId);
                            item2.setPriceToSell(price);
                            buy1.addItem(item2);
                        }
                        this._lists.put(new Integer(buy1.getListId()), buy1);
                        this._nextListId = Math.max(this._nextListId, buy1.getListId() + 1);
                    }
                    rset.close();
                    statement.close();
                }
                rset1.close();
                statement1.close();
                if (Config.DEBUG) {
                    _log.fine("created " + dummyItemCount + " Dummy-Items for buylists");
                }
                _log.config("TradeController: Loaded " + this._lists.size() + " Buylists.");
            }
            catch (Exception e) {
                _log.warning("TradeController: Buylists could not be initialized.");
                e.printStackTrace();
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private int parseList(String line) {
        int itemCreated = 0;
        StringTokenizer st = new StringTokenizer(line, ";");
        int listId = Integer.parseInt(st.nextToken());
        L2TradeList buy1 = new L2TradeList(listId);
        while (st.hasMoreTokens()) {
            int itemId = Integer.parseInt(st.nextToken());
            int price = Integer.parseInt(st.nextToken());
            L2ItemInstance item = ItemTable.getInstance().createDummyItem(itemId);
            item.setPriceToSell(price);
            buy1.addItem(item);
            ++itemCreated;
        }
        this._lists.put(new Integer(buy1.getListId()), buy1);
        return itemCreated;
    }

    public L2TradeList getBuyList(int listId) {
        return this._lists.get(new Integer(listId));
    }

    public synchronized int getNextId() {
        return this._nextListId++;
    }
}

