/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.l2j.gameserver.TradeController;
import net.sf.l2j.gameserver.lib.MySqlUtils;
import net.sf.l2j.gameserver.model.L2Territory;

public class Territory {
    private static Logger _log = Logger.getLogger(TradeController.class.getName());
    private static final Territory _instance = new Territory();
    private static HashMap<Integer, L2Territory> _territory;

    public static Territory getInstance() {
        return _instance;
    }

    private Territory() {
        this.reload_data();
    }

    public int[] getRandomPoint(int terr) {
        return _territory.get(terr).getRandomPoint();
    }

    public int getProcMax(int terr) {
        return _territory.get(terr).getProcMax();
    }

    public void reload_data() {
        Integer[][] point;
        _territory = new HashMap();
        for (Integer[] row : point = MySqlUtils.get2DIntArray(new String[]{"loc_id", "loc_x", "loc_y", "loc_zmin", "loc_zmax", "proc"}, "locations", "1")) {
            Integer terr = row[0];
            if (terr == null) {
                _log.warning("Null territory!");
                continue;
            }
            if (_territory.get(terr) == null) {
                L2Territory t = new L2Territory(terr);
                _territory.put(terr, t);
            }
            _territory.get(terr).add(row[1], row[2], row[3], row[4], row[5]);
        }
    }
}

