/*
 * Decompiled with CFR 0.152.
 */
package net.sf.l2j.gameserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.NpcTable;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpawnTable {
    private static Logger _log = Logger.getLogger(SpawnTable.class.getName());
    private static final SpawnTable _instance = new SpawnTable();
    private HashMap<Integer, L2Spawn> _spawntable;
    private int _npcSpawnCount;
    private int _highestId;

    public static SpawnTable getInstance() {
        return _instance;
    }

    private SpawnTable() {
        this.fillSpawnTable();
    }

    public HashMap<Integer, L2Spawn> getSpawnTable() {
        return this._spawntable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSpawnTable() {
        this._spawntable = new HashMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, location, count, npc_templateid, locx, locy, locz, randomx, randomy, heading, respawn_delay, loc_id FROM spawnlist");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2Spawn spawnDat;
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (!Config.CG_SPAWNSIEGEGUARDS && template1 != null && template1.factionId != null && template1.factionId.contains("siege")) continue;
                if (template1 == null) {
                    _log.warning("mob data for id:" + rset.getInt("npc_templateid") + " missing in npc table");
                    spawnDat = null;
                } else {
                    spawnDat = new L2Spawn(template1);
                    spawnDat.setId(rset.getInt("id"));
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    spawnDat.setLocation(rset.getInt("loc_id"));
                    this._npcSpawnCount += spawnDat.init();
                }
                this._spawntable.put(spawnDat.getId(), spawnDat);
                if (spawnDat.getId() <= this._highestId) continue;
                this._highestId = spawnDat.getId();
            }
            rset.close();
            statement.close();
        }
        catch (Exception e1) {
            _log.warning("spawn couldnt be initialized:" + e1);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        _log.config("SpawnTable: Loaded " + this._spawntable.size() + " Npc Spawn Locations.");
        if (Config.DEBUG) {
            _log.fine("Spawning completed, total number of NPCs in the world: " + this._npcSpawnCount);
        }
    }

    public L2Spawn getTemplate(int id) {
        return this._spawntable.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSpawn(L2Spawn spawn, boolean storeInDb) {
        ++this._highestId;
        spawn.setId(this._highestId);
        this._spawntable.put(new Integer(spawn.getId()), spawn);
        if (storeInDb) {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("INSERT INTO spawnlist (location,count,npc_templateid,locx,locy,locz,heading,respawn_delay,loc_id) values(?,?,?,?,?,?,?,?,?)");
                statement.setString(1, "");
                statement.setInt(2, spawn.getAmount());
                statement.setInt(3, spawn.getNpcid());
                statement.setInt(4, spawn.getLocx());
                statement.setInt(5, spawn.getLocy());
                statement.setInt(6, spawn.getLocz());
                statement.setInt(7, spawn.getHeading());
                statement.setInt(8, spawn.getRespawnDelay() / 1000);
                statement.setInt(9, spawn.getLocation());
                statement.execute();
                statement.close();
            }
            catch (Exception e1) {
                _log.warning("spawn couldnt be stored in db:" + e1);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpawn(L2Spawn spawn, boolean updateDb) {
        if (this._spawntable.remove(new Integer(spawn.getId())) != null && updateDb) {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("DELETE FROM spawnlist WHERE id=?");
                statement.setInt(1, spawn.getId());
                statement.execute();
                statement.close();
            }
            catch (Exception e1) {
                _log.warning("spawn couldnt be deleted in db:" + e1);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

